/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.exchange;

import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import microsoft.exchange.webservices.data.core.ExchangeService;
import microsoft.exchange.webservices.data.core.enumeration.availability.AvailabilityData;
import microsoft.exchange.webservices.data.core.enumeration.misc.ConnectingIdType;
import microsoft.exchange.webservices.data.core.enumeration.misc.ExchangeVersion;
import microsoft.exchange.webservices.data.core.enumeration.property.LegacyFreeBusyStatus;
import microsoft.exchange.webservices.data.core.enumeration.property.MeetingResponseType;
import microsoft.exchange.webservices.data.core.enumeration.property.WellKnownFolderName;
import microsoft.exchange.webservices.data.core.enumeration.property.time.DayOfTheWeek;
import microsoft.exchange.webservices.data.core.enumeration.search.LogicalOperator;
import microsoft.exchange.webservices.data.core.enumeration.service.ConflictResolutionMode;
import microsoft.exchange.webservices.data.core.enumeration.service.DeleteMode;
import microsoft.exchange.webservices.data.core.enumeration.service.SendInvitationsMode;
import microsoft.exchange.webservices.data.core.enumeration.service.SendInvitationsOrCancellationsMode;
import microsoft.exchange.webservices.data.core.enumeration.service.ServiceResult;
import microsoft.exchange.webservices.data.core.exception.http.HttpErrorException;
import microsoft.exchange.webservices.data.core.exception.service.remote.ServiceRequestException;
import microsoft.exchange.webservices.data.core.exception.service.remote.ServiceResponseException;
import microsoft.exchange.webservices.data.core.response.AttendeeAvailability;
import microsoft.exchange.webservices.data.core.service.folder.CalendarFolder;
import microsoft.exchange.webservices.data.core.service.folder.Folder;
import microsoft.exchange.webservices.data.core.service.item.Appointment;
import microsoft.exchange.webservices.data.core.service.item.EmailMessage;
import microsoft.exchange.webservices.data.core.service.item.Item;
import microsoft.exchange.webservices.data.core.service.schema.EmailMessageSchema;
import microsoft.exchange.webservices.data.credential.ExchangeCredentials;
import microsoft.exchange.webservices.data.credential.WebCredentials;
import microsoft.exchange.webservices.data.misc.ImpersonatedUserId;
import microsoft.exchange.webservices.data.misc.availability.AttendeeInfo;
import microsoft.exchange.webservices.data.misc.availability.GetUserAvailabilityResults;
import microsoft.exchange.webservices.data.misc.availability.TimeWindow;
import microsoft.exchange.webservices.data.property.complex.Attendee;
import microsoft.exchange.webservices.data.property.complex.AttendeeCollection;
import microsoft.exchange.webservices.data.property.complex.EmailAddress;
import microsoft.exchange.webservices.data.property.complex.FolderId;
import microsoft.exchange.webservices.data.property.complex.ItemId;
import microsoft.exchange.webservices.data.property.complex.Mailbox;
import microsoft.exchange.webservices.data.property.complex.MessageBody;
import microsoft.exchange.webservices.data.property.complex.recurrence.pattern.Recurrence;
import microsoft.exchange.webservices.data.property.complex.time.TimeZoneDefinition;
import microsoft.exchange.webservices.data.property.definition.PropertyDefinitionBase;
import microsoft.exchange.webservices.data.search.CalendarView;
import microsoft.exchange.webservices.data.search.FindItemsResults;
import microsoft.exchange.webservices.data.search.ItemView;
import microsoft.exchange.webservices.data.search.filter.SearchFilter;
import microsoft.exchange.webservices.data.util.TimeZoneUtils;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.core.userpref.UserPreferencesException;
import org.ametys.core.util.DateUtils;
import org.ametys.core.util.SessionAttributeProvider;
import org.ametys.plugins.messagingconnector.AbstractMessagingConnector;
import org.ametys.plugins.messagingconnector.CalendarEvent;
import org.ametys.plugins.messagingconnector.EventRecurrenceTypeEnum;
import org.ametys.plugins.messagingconnector.MessagingConnector;
import org.ametys.plugins.messagingconnector.MessagingConnectorException;
import org.ametys.runtime.config.Config;
import org.ametys.web.WebSessionAttributeProvider;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;

public class EWSConnector
extends AbstractMessagingConnector {
    public static final String INNER_ROLE = EWSConnector.class.getName();
    private UserManager _userManager;
    private WebSessionAttributeProvider _sessionAttributeProvider;

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._userManager = (UserManager)manager.lookup(UserManager.ROLE);
        this._sessionAttributeProvider = (WebSessionAttributeProvider)manager.lookup(SessionAttributeProvider.ROLE);
    }

    protected ExchangeService getService(UserIdentity userIdentity) throws URISyntaxException {
        if (userIdentity == null) {
            return null;
        }
        String url = (String)Config.getInstance().getValue("org.ametys.plugins.exchange.url");
        String identity = (String)Config.getInstance().getValue("org.ametys.plugins.exchange.identity");
        ExchangeService service = null;
        switch (identity) {
            case "impersonate": {
                service = this._getImpersonatedService(userIdentity);
                break;
            }
            case "userprefs": {
                service = this._getServiceByUserPrefs(userIdentity);
                break;
            }
            case "session": {
                service = this._getServiceBySession(userIdentity);
                break;
            }
        }
        if (service != null) {
            service.setUrl(new URI(url));
        }
        return service;
    }

    public boolean supportUserCredential(UserIdentity userIdentity) {
        String identity = (String)Config.getInstance().getValue("org.ametys.plugins.exchange.identity");
        return identity.equals("userprefs");
    }

    private String _getUserPrincipalName(UserIdentity userIdentity) {
        String authMethod = (String)Config.getInstance().getValue("org.ametys.plugins.exchange.authmethodews");
        if ("email".equals(authMethod)) {
            User user = this._userManager.getUser(userIdentity);
            String email = user.getEmail();
            if (StringUtils.isBlank((CharSequence)email)) {
                if (this.getLogger().isWarnEnabled()) {
                    this.getLogger().warn("The user '" + userIdentity.getLogin() + "' has no email address set, thus exchange cannot be contacted using 'email' authentication method");
                }
                return null;
            }
            return email;
        }
        return userIdentity.getLogin();
    }

    private ExchangeService _getServiceByUserPrefs(UserIdentity userIdentity) {
        String userName = this._getUserPrincipalName(userIdentity);
        String password = null;
        try {
            password = this.getUserPassword(userIdentity);
            if (userName != null && password != null) {
                ExchangeService service = this._initService(userName, password);
                return service;
            }
            if (password == null) {
                throw new MessagingConnectorException("Missing exchange password for user " + String.valueOf(userIdentity), MessagingConnectorException.ExceptionType.UNAUTHORIZED);
            }
            return null;
        }
        catch (UserPreferencesException e) {
            this.getLogger().error("Unable to get exchange user password for user'" + userIdentity.getLogin() + "'", (Throwable)e);
            return null;
        }
    }

    private ExchangeService _getServiceBySession(UserIdentity userIdentity) {
        String userName = this._getUserPrincipalName(userIdentity);
        Optional password = this._sessionAttributeProvider.getSessionAttribute("runtime.authentication.password");
        if (userName != null && password.isPresent()) {
            ExchangeService service = this._initService(userName, (String)password.get());
            return service;
        }
        if (password.isEmpty()) {
            throw new MessagingConnectorException("Missing exchange password for user " + String.valueOf(userIdentity) + ".\n Check that you use a FormCredentialProvider with the corresponding parameter checked", MessagingConnectorException.ExceptionType.UNAUTHORIZED);
        }
        return null;
    }

    private ExchangeService _getImpersonatedService(UserIdentity userIdentity) {
        String userName = (String)Config.getInstance().getValue("org.ametys.plugins.exchange.username");
        String password = (String)Config.getInstance().getValue("org.ametys.plugins.exchange.password");
        ExchangeService service = this._initService(userName, password);
        String authMethod = (String)Config.getInstance().getValue("org.ametys.plugins.exchange.authmethodews");
        if ("email".equals(authMethod)) {
            User user = this._userManager.getUser(userIdentity);
            String email = user.getEmail();
            if (StringUtils.isBlank((CharSequence)email)) {
                if (this.getLogger().isWarnEnabled()) {
                    this.getLogger().warn("The user '" + userIdentity.getLogin() + "' has no email address set, thus exchange cannot be contacted using 'email' authentication method");
                }
                return null;
            }
            service.setImpersonatedUserId(new ImpersonatedUserId(ConnectingIdType.SmtpAddress, email));
        } else {
            service.setImpersonatedUserId(new ImpersonatedUserId(ConnectingIdType.PrincipalName, userIdentity.getLogin()));
        }
        return service;
    }

    private ExchangeService _initService(String userName, String password) {
        ExchangeService service = new ExchangeService(ExchangeVersion.Exchange2010_SP2);
        WebCredentials credentials = new WebCredentials(userName, password);
        service.setCredentials((ExchangeCredentials)credentials);
        return service;
    }

    protected List<CalendarEvent> internalGetEvents(UserIdentity userIdentity, int maxDays, int maxEvents) throws MessagingConnectorException {
        try {
            ArrayList<CalendarEvent> calendar = new ArrayList<CalendarEvent>();
            ExchangeService service = this.getService(userIdentity);
            if (service != null) {
                CalendarFolder cf = CalendarFolder.bind((ExchangeService)service, (WellKnownFolderName)WellKnownFolderName.Calendar);
                ZonedDateTime nowZdt = ZonedDateTime.now();
                Date fromDate = DateUtils.asDate((ZonedDateTime)nowZdt.withSecond(0));
                Date untilDate = DateUtils.asDate((ZonedDateTime)nowZdt.withHour(0).withMinute(0).withSecond(0).plusDays(maxDays));
                CalendarView calendarView = new CalendarView(fromDate, untilDate);
                FindItemsResults findResultsEvent = cf.findAppointments(calendarView);
                calendarView.setMaxItemsReturned(maxEvents > 0 ? Integer.valueOf(maxEvents) : null);
                findResultsEvent = cf.findAppointments(calendarView);
                for (Appointment event : findResultsEvent.getItems()) {
                    CalendarEvent newEvent = new CalendarEvent();
                    newEvent.setStartDate(event.getStart());
                    newEvent.setEndDate(event.getEnd());
                    newEvent.setSubject(event.getSubject());
                    newEvent.setLocation(event.getLocation());
                    calendar.add(newEvent);
                }
            }
            return calendar;
        }
        catch (ServiceRequestException e) {
            Throwable cause = e.getCause();
            MessagingConnectorException.ExceptionType type = this._getExceptionType(cause, userIdentity);
            throw new MessagingConnectorException("Failed to get the events for user " + userIdentity.toString(), type, (Throwable)e);
        }
        catch (Exception e) {
            throw new MessagingConnectorException("Failed to get the events for user " + userIdentity.toString(), (Throwable)e);
        }
    }

    protected int internalGetEventsCount(UserIdentity userIdentity, int maxDays) throws MessagingConnectorException {
        try {
            int nextEventsCount = 0;
            ExchangeService service = this.getService(userIdentity);
            if (service != null) {
                CalendarFolder cf = CalendarFolder.bind((ExchangeService)service, (WellKnownFolderName)WellKnownFolderName.Calendar);
                ZonedDateTime nowZdt = ZonedDateTime.now();
                Date fromDate = DateUtils.asDate((ZonedDateTime)nowZdt.withSecond(0));
                Date untilDate = DateUtils.asDate((ZonedDateTime)nowZdt.withHour(0).withMinute(0).withSecond(0).plusDays(maxDays));
                CalendarView calendarView = new CalendarView(fromDate, untilDate);
                FindItemsResults findResultsEvent = cf.findAppointments(calendarView);
                nextEventsCount = findResultsEvent.getTotalCount();
            }
            return nextEventsCount;
        }
        catch (ServiceRequestException e) {
            Throwable cause = e.getCause();
            MessagingConnectorException.ExceptionType type = this._getExceptionType(cause, userIdentity);
            throw new MessagingConnectorException("Failed to get the events count for user " + userIdentity.toString(), type, (Throwable)e);
        }
        catch (MessagingConnectorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MessagingConnectorException("Failed to get the events count for user " + userIdentity.toString(), (Throwable)e);
        }
    }

    protected List<org.ametys.plugins.messagingconnector.EmailMessage> internalGetEmails(UserIdentity userIdentity, int maxEmails) throws MessagingConnectorException {
        try {
            ArrayList<org.ametys.plugins.messagingconnector.EmailMessage> mailMessage = new ArrayList<org.ametys.plugins.messagingconnector.EmailMessage>();
            ExchangeService service = this.getService(userIdentity);
            if (service != null) {
                SearchFilter.SearchFilterCollection sf = new SearchFilter.SearchFilterCollection(LogicalOperator.And, new SearchFilter[]{new SearchFilter.IsEqualTo((PropertyDefinitionBase)EmailMessageSchema.IsRead, (Object)false)});
                ItemView view = new ItemView(maxEmails);
                FindItemsResults findResultsMail = service.findItems(WellKnownFolderName.Inbox, (SearchFilter)sf, view);
                ArrayList messagesReceived = findResultsMail.getItems();
                for (Item message : messagesReceived) {
                    message.load();
                    org.ametys.plugins.messagingconnector.EmailMessage newMessage = new org.ametys.plugins.messagingconnector.EmailMessage();
                    EmailAddress sender = ((EmailMessage)message).getSender();
                    if (sender != null) {
                        newMessage.setSender(sender.getAddress());
                    }
                    if (message.getSubject() != null) {
                        newMessage.setSubject(message.getSubject());
                    }
                    if (message.getBody() != null) {
                        newMessage.setSummary(EWSConnector.html2text(message.getBody().toString()));
                    }
                    mailMessage.add(newMessage);
                }
            }
            return mailMessage;
        }
        catch (ServiceRequestException e) {
            Throwable cause = e.getCause();
            MessagingConnectorException.ExceptionType type = this._getExceptionType(cause, userIdentity);
            throw new MessagingConnectorException("Failed to get the emails for user " + userIdentity.toString(), type, (Throwable)e);
        }
        catch (MessagingConnectorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MessagingConnectorException("Failed to get the emails for user " + userIdentity.toString(), (Throwable)e);
        }
    }

    protected int internalGetEmailsCount(UserIdentity userIdentity) throws MessagingConnectorException {
        try {
            int emailsCount = 0;
            ExchangeService service = this.getService(userIdentity);
            if (service != null) {
                SearchFilter.SearchFilterCollection sf = new SearchFilter.SearchFilterCollection(LogicalOperator.And, new SearchFilter[]{new SearchFilter.IsEqualTo((PropertyDefinitionBase)EmailMessageSchema.IsRead, (Object)false)});
                ItemView view = new ItemView(20);
                FindItemsResults findResultsMail = service.findItems(WellKnownFolderName.Inbox, (SearchFilter)sf, view);
                emailsCount = findResultsMail.getTotalCount();
            }
            return emailsCount;
        }
        catch (ServiceRequestException e) {
            Throwable cause = e.getCause();
            MessagingConnectorException.ExceptionType type = this._getExceptionType(cause, userIdentity);
            throw new MessagingConnectorException("Failed to get the emails for user " + userIdentity.toString(), type, (Throwable)e);
        }
        catch (MessagingConnectorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MessagingConnectorException("Failed to get the emails for user " + userIdentity.toString(), (Throwable)e);
        }
    }

    public boolean supportInvitation() throws MessagingConnectorException {
        return true;
    }

    public boolean internalIsEventExist(String eventId, UserIdentity organiser) throws MessagingConnectorException {
        try {
            ExchangeService service = this.getService(organiser);
            if (service != null) {
                ItemId itemId = new ItemId(eventId);
                Appointment appointment = Appointment.bind((ExchangeService)service, (ItemId)itemId);
                return appointment != null;
            }
        }
        catch (ServiceResponseException e) {
            Throwable cause = e.getCause();
            MessagingConnectorException.ExceptionType type = this._getExceptionType(cause, organiser);
            if (type == MessagingConnectorException.ExceptionType.UNKNOWN) {
                return false;
            }
            throw new MessagingConnectorException("Failed to get event " + eventId + " from organiser " + organiser.toString(), type, (Throwable)e);
        }
        catch (MessagingConnectorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MessagingConnectorException("Failed to get event " + eventId + " from organiser " + organiser.toString(), (Throwable)e);
        }
        return false;
    }

    public String internalCreateEvent(String title, String description, String place, boolean isAllDay, ZonedDateTime startDate, ZonedDateTime endDate, EventRecurrenceTypeEnum recurrenceType, ZonedDateTime untilDate, Map<String, Boolean> attendees, UserIdentity organiser) throws MessagingConnectorException {
        try {
            ExchangeService service = this.getService(organiser);
            if (service != null) {
                Appointment appointment = new Appointment(service);
                this._setDataEvent(service, appointment, title, description, place, isAllDay, DateUtils.asDate((ZonedDateTime)startDate), DateUtils.asDate((ZonedDateTime)endDate), recurrenceType, DateUtils.asDate((ZonedDateTime)untilDate), attendees);
                User organiserUser = this._userManager.getUser(organiser);
                Mailbox mailBox = new Mailbox(organiserUser.getEmail());
                appointment.save(new FolderId(WellKnownFolderName.Calendar, mailBox), SendInvitationsMode.SendOnlyToAll);
                return appointment.getId().getUniqueId();
            }
        }
        catch (ServiceRequestException e) {
            Throwable cause = e.getCause();
            MessagingConnectorException.ExceptionType type = this._getExceptionType(cause, organiser);
            throw new MessagingConnectorException("Failed to create event from organiser " + organiser.toString(), type, (Throwable)e);
        }
        catch (MessagingConnectorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MessagingConnectorException("Failed to create event from organiser " + organiser.toString(), (Throwable)e);
        }
        return null;
    }

    public void internalUpdateEvent(String eventId, String title, String description, String place, boolean isAllDay, ZonedDateTime startDate, ZonedDateTime endDate, EventRecurrenceTypeEnum recurrenceType, ZonedDateTime untilDate, Map<String, Boolean> attendees, UserIdentity organiser) throws MessagingConnectorException {
        try {
            ExchangeService service = this.getService(organiser);
            if (service != null) {
                ItemId itemId = new ItemId(eventId);
                Appointment appointment = Appointment.bind((ExchangeService)service, (ItemId)itemId);
                this._setDataEvent(service, appointment, title, description, place, isAllDay, DateUtils.asDate((ZonedDateTime)startDate), DateUtils.asDate((ZonedDateTime)endDate), recurrenceType, DateUtils.asDate((ZonedDateTime)untilDate), attendees);
                appointment.update(ConflictResolutionMode.AlwaysOverwrite, SendInvitationsOrCancellationsMode.SendOnlyToAll);
            }
        }
        catch (ServiceRequestException e) {
            Throwable cause = e.getCause();
            MessagingConnectorException.ExceptionType type = this._getExceptionType(cause, organiser);
            throw new MessagingConnectorException("Failed to update event from organiser " + organiser.toString(), type, (Throwable)e);
        }
        catch (MessagingConnectorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MessagingConnectorException("Failed to update event from organiser " + organiser.toString(), (Throwable)e);
        }
    }

    private void _setDataEvent(ExchangeService service, Appointment appointment, String title, String description, String place, boolean isAllDay, Date startDate, Date endDate, EventRecurrenceTypeEnum recurrenceType, Date untilDate, Map<String, Boolean> attendees) throws Exception {
        TimeZone defaultTimeZone = TimeZone.getDefault();
        Map olsonTimeZoneToMsMap = TimeZoneUtils.createOlsonTimeZoneToMsMap();
        String msTimeZoneId = (String)olsonTimeZoneToMsMap.get(defaultTimeZone.getID());
        Collection serverTimeZones = service.getServerTimeZones(Collections.singletonList(msTimeZoneId));
        TimeZoneDefinition timeZone = (TimeZoneDefinition)serverTimeZones.iterator().next();
        appointment.setSubject(title);
        appointment.setBody(new MessageBody(description));
        appointment.setStart(startDate);
        if (isAllDay) {
            Date date = Date.from(endDate.toInstant().atZone(ZoneId.systemDefault()).plusDays(1L).toInstant());
            appointment.setEnd(date);
        } else {
            appointment.setEnd(endDate);
        }
        appointment.setIsAllDayEvent(Boolean.valueOf(isAllDay));
        appointment.setLocation(place);
        appointment.setStartTimeZone(timeZone);
        appointment.setEndTimeZone(timeZone);
        this._setRecurrence(appointment, startDate, recurrenceType, untilDate);
        this._setAttendees(appointment, attendees);
    }

    private void _setRecurrence(Appointment appointment, Date startDate, EventRecurrenceTypeEnum recurrenceType, Date untilDate) throws Exception {
        Recurrence.DailyPattern recurrence = null;
        switch (recurrenceType) {
            case ALL_DAY: {
                recurrence = new Recurrence.DailyPattern(startDate, 1);
                break;
            }
            case ALL_WORKING_DAY: {
                String workingDayAsString = (String)Config.getInstance().getValue("org.ametys.plugins.explorer.calendar.event.working.day");
                ArrayList<DayOfTheWeek> days = new ArrayList<DayOfTheWeek>();
                for (String idDay : StringUtils.split((String)workingDayAsString, (String)",")) {
                    days.add((DayOfTheWeek)EnumUtils.getEnumList(DayOfTheWeek.class).get(Integer.parseInt(idDay) - 1));
                }
                recurrence = new Recurrence.WeeklyPattern(startDate, 1, days.toArray(new DayOfTheWeek[days.size()]));
                break;
            }
            case WEEKLY: {
                ZonedDateTime startWeeklyDateTime = startDate.toInstant().atZone(ZoneId.systemDefault());
                int dayOfWeekForWeekly = startWeeklyDateTime.getDayOfWeek().getValue();
                recurrence = new Recurrence.WeeklyPattern(startDate, 1, new DayOfTheWeek[]{(DayOfTheWeek)EnumUtils.getEnumList(DayOfTheWeek.class).get(dayOfWeekForWeekly % 7)});
                break;
            }
            case BIWEEKLY: {
                ZonedDateTime startBiWeeklyDateTime = startDate.toInstant().atZone(ZoneId.systemDefault());
                int dayOfWeekForBiWeekly = startBiWeeklyDateTime.getDayOfWeek().getValue();
                recurrence = new Recurrence.WeeklyPattern(startDate, 2, new DayOfTheWeek[]{(DayOfTheWeek)EnumUtils.getEnumList(DayOfTheWeek.class).get(dayOfWeekForBiWeekly % 7)});
                break;
            }
            case MONTHLY: {
                ZonedDateTime startMonthlyDateTime = startDate.toInstant().atZone(ZoneId.systemDefault());
                int dayOfMonth = startMonthlyDateTime.getDayOfMonth();
                recurrence = new Recurrence.MonthlyPattern(startDate, 1, dayOfMonth);
                break;
            }
        }
        if (untilDate != null && recurrence != null) {
            recurrence.setEndDate(untilDate);
            appointment.setRecurrence((Recurrence)recurrence);
        }
    }

    public void internalDeleteEvent(String eventId, UserIdentity organiser) throws MessagingConnectorException {
        try {
            ExchangeService service = this.getService(organiser);
            if (service != null) {
                ItemId itemId = new ItemId(eventId);
                Appointment appointment = Appointment.bind((ExchangeService)service, (ItemId)itemId);
                appointment.delete(DeleteMode.MoveToDeletedItems);
            }
        }
        catch (ServiceRequestException e) {
            Throwable cause = e.getCause();
            MessagingConnectorException.ExceptionType type = this._getExceptionType(cause, organiser);
            throw new MessagingConnectorException("Failed to delete event " + eventId + " with organiser " + organiser.toString(), type, (Throwable)e);
        }
        catch (Exception e) {
            throw new MessagingConnectorException("Failed to delete event " + eventId + " with organiser " + organiser.toString(), (Throwable)e);
        }
    }

    public Map<String, MessagingConnector.AttendeeInformation> internalGetAttendees(String eventId, UserIdentity organiser) throws MessagingConnectorException {
        HashMap<String, MessagingConnector.AttendeeInformation> attendees = new HashMap<String, MessagingConnector.AttendeeInformation>();
        try {
            ExchangeService service = this.getService(organiser);
            if (service != null) {
                MessagingConnector.AttendeeInformation attendeeInformation;
                MessagingConnector.ResponseType responseStatus;
                ItemId itemId = new ItemId(eventId);
                Appointment appointment = Appointment.bind((ExchangeService)service, (ItemId)itemId);
                for (Attendee attendee : appointment.getRequiredAttendees()) {
                    responseStatus = this._getResponseStatus(attendee.getResponseType());
                    attendeeInformation = new MessagingConnector.AttendeeInformation(true, responseStatus);
                    attendees.put(attendee.getAddress(), attendeeInformation);
                }
                for (Attendee attendee : appointment.getOptionalAttendees()) {
                    responseStatus = this._getResponseStatus(attendee.getResponseType());
                    attendeeInformation = new MessagingConnector.AttendeeInformation(false, responseStatus);
                    attendees.put(attendee.getAddress(), attendeeInformation);
                }
            }
        }
        catch (ServiceResponseException e) {
            Throwable cause = e.getCause();
            MessagingConnectorException.ExceptionType type = this._getExceptionType(cause, organiser);
            if (type == MessagingConnectorException.ExceptionType.UNKNOWN) {
                return attendees;
            }
            throw new MessagingConnectorException("Failed to get attendees from event " + eventId + " with organiser " + organiser.toString(), type, (Throwable)e);
        }
        catch (Exception e) {
            throw new MessagingConnectorException("Failed to get attendees from event " + eventId + " with organiser " + organiser.toString(), (Throwable)e);
        }
        return attendees;
    }

    public void internalSetAttendees(String eventId, Map<String, Boolean> attendees, UserIdentity organiser) throws MessagingConnectorException {
        try {
            ExchangeService service = this.getService(organiser);
            if (service != null) {
                ItemId itemId = new ItemId(eventId);
                Appointment appointment = Appointment.bind((ExchangeService)service, (ItemId)itemId);
                this._setAttendees(appointment, attendees);
                appointment.update(ConflictResolutionMode.AlwaysOverwrite, SendInvitationsOrCancellationsMode.SendOnlyToChanged);
            }
        }
        catch (ServiceRequestException e) {
            Throwable cause = e.getCause();
            MessagingConnectorException.ExceptionType type = this._getExceptionType(cause, organiser);
            throw new MessagingConnectorException("Failed to get attendees from event " + eventId + " with organiser " + organiser.toString(), type, (Throwable)e);
        }
        catch (Exception e) {
            throw new MessagingConnectorException("Failed to get attendees from event " + eventId + " with organiser " + organiser.toString(), (Throwable)e);
        }
    }

    public Map<String, MessagingConnector.FreeBusyStatus> internalGetFreeBusy(Date startDate, Date endDate, boolean isAllDay, Set<String> attendees, UserIdentity organiser) throws MessagingConnectorException {
        HashMap<String, MessagingConnector.FreeBusyStatus> attendeesMap = new HashMap<String, MessagingConnector.FreeBusyStatus>();
        if (attendees.isEmpty()) {
            return attendeesMap;
        }
        try {
            ExchangeService service = this.getService(organiser);
            if (service != null) {
                TimeWindow timeWindow = null;
                if (isAllDay) {
                    Date endDatePlus1 = Date.from(endDate.toInstant().atZone(ZoneId.systemDefault()).plusDays(1L).toInstant());
                    timeWindow = new TimeWindow(startDate, endDatePlus1);
                } else {
                    Date startDateMinus1 = Date.from(startDate.toInstant().atZone(ZoneId.systemDefault()).minusDays(1L).toInstant());
                    Date endDatePlus1 = Date.from(endDate.toInstant().atZone(ZoneId.systemDefault()).plusDays(1L).toInstant());
                    timeWindow = new TimeWindow(startDateMinus1, endDatePlus1);
                }
                ArrayList<AttendeeInfo> attendeesInfo = new ArrayList<AttendeeInfo>();
                for (String email : attendees) {
                    attendeesInfo.add(new AttendeeInfo(email));
                }
                GetUserAvailabilityResults userAvailability = service.getUserAvailability(attendeesInfo, timeWindow, AvailabilityData.FreeBusy);
                int index = 0;
                for (AttendeeAvailability availability : userAvailability.getAttendeesAvailability()) {
                    AttendeeInfo attendeeInfo = (AttendeeInfo)attendeesInfo.get(index);
                    String email = attendeeInfo.getSmtpAddress();
                    MessagingConnector.FreeBusyStatus freeBusyStatus = MessagingConnector.FreeBusyStatus.Unknown;
                    if (!ServiceResult.Error.equals((Object)availability.getResult())) {
                        freeBusyStatus = MessagingConnector.FreeBusyStatus.Free;
                        for (microsoft.exchange.webservices.data.property.complex.availability.CalendarEvent calEvent : availability.getCalendarEvents()) {
                            if (isAllDay) {
                                if (!calEvent.getFreeBusyStatus().equals((Object)LegacyFreeBusyStatus.Busy)) continue;
                                freeBusyStatus = MessagingConnector.FreeBusyStatus.Busy;
                                continue;
                            }
                            if (!calEvent.getFreeBusyStatus().equals((Object)LegacyFreeBusyStatus.Busy) || !startDate.before(calEvent.getEndTime()) || !endDate.after(calEvent.getStartTime())) continue;
                            freeBusyStatus = MessagingConnector.FreeBusyStatus.Busy;
                        }
                    }
                    attendeesMap.put(email, freeBusyStatus);
                    ++index;
                }
            }
        }
        catch (ServiceRequestException e) {
            Throwable cause = e.getCause();
            MessagingConnectorException.ExceptionType type = this._getExceptionType(cause, organiser);
            throw new MessagingConnectorException("Failed to get free/busy with organiser " + organiser.toString(), type, (Throwable)e);
        }
        catch (Exception e) {
            throw new MessagingConnectorException("Failed to get free/busy with organiser " + organiser.toString(), (Throwable)e);
        }
        return attendeesMap;
    }

    public boolean isUserExist(UserIdentity userIdentity) throws MessagingConnectorException {
        try {
            ExchangeService service = this.getService(userIdentity);
            if (service != null) {
                Folder.bind((ExchangeService)service, (WellKnownFolderName)WellKnownFolderName.Inbox);
                return true;
            }
            return false;
        }
        catch (ServiceRequestException e) {
            Throwable cause = e.getCause();
            MessagingConnectorException.ExceptionType type = this._getExceptionType(cause, userIdentity);
            if (type == MessagingConnectorException.ExceptionType.UNKNOWN) {
                return false;
            }
            throw new MessagingConnectorException("Failed to know if user " + userIdentity.getLogin() + " exist in exchange", type, (Throwable)e);
        }
        catch (Exception e) {
            throw new MessagingConnectorException("Failed to know if user " + userIdentity.getLogin() + " exist in exchange", (Throwable)e);
        }
    }

    private MessagingConnector.ResponseType _getResponseStatus(MeetingResponseType meetingResponseType) {
        switch (meetingResponseType) {
            case Accept: {
                return MessagingConnector.ResponseType.Accept;
            }
            case Decline: {
                return MessagingConnector.ResponseType.Decline;
            }
            case Tentative: {
                return MessagingConnector.ResponseType.Maybe;
            }
        }
        return MessagingConnector.ResponseType.Unknown;
    }

    private void _setAttendees(Appointment appointment, Map<String, Boolean> attendees) throws Exception {
        if (attendees != null) {
            AttendeeCollection requiredAttendees = appointment.getRequiredAttendees();
            AttendeeCollection optionalAttendees = appointment.getOptionalAttendees();
            requiredAttendees.clear();
            optionalAttendees.clear();
            for (String email : attendees.keySet()) {
                boolean isMandatory = attendees.get(email);
                if (isMandatory) {
                    requiredAttendees.add(new Attendee(email));
                    continue;
                }
                optionalAttendees.add(new Attendee(email));
            }
        }
    }

    protected static String html2text(String html) {
        return Jsoup.parse((String)html).text();
    }

    private MessagingConnectorException.ExceptionType _getExceptionType(Throwable exception, UserIdentity userIdentity) {
        MessagingConnectorException.ExceptionType type = MessagingConnectorException.ExceptionType.UNKNOWN;
        if (exception == null) {
            return MessagingConnectorException.ExceptionType.UNKNOWN;
        }
        HttpErrorException httpException = null;
        if (exception instanceof HttpErrorException) {
            httpException = (HttpErrorException)exception;
        }
        if (exception.getCause() instanceof HttpErrorException) {
            httpException = (HttpErrorException)exception.getCause();
        }
        if (httpException != null) {
            int httpErrorCode = httpException.getHttpErrorCode();
            if (httpErrorCode == 401) {
                type = !this.supportUserCredential(userIdentity) ? MessagingConnectorException.ExceptionType.CONFIGURATION_EXCEPTION : MessagingConnectorException.ExceptionType.UNAUTHORIZED;
            } else if (httpErrorCode == 404) {
                type = MessagingConnectorException.ExceptionType.CONFIGURATION_EXCEPTION;
            }
        } else if (exception.getCause() instanceof UnknownHostException) {
            type = MessagingConnectorException.ExceptionType.CONFIGURATION_EXCEPTION;
        } else if (exception.getCause() instanceof SocketTimeoutException) {
            type = MessagingConnectorException.ExceptionType.TIMEOUT;
        }
        return type;
    }
}

