/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.exchange;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.core.user.directory.UserDirectory;
import org.ametys.core.user.population.UserPopulation;
import org.ametys.plugins.exchange.EWSConnector;
import org.ametys.plugins.exchange.GraphConnector;
import org.ametys.plugins.messagingconnector.AbstractMessagingConnector;
import org.ametys.plugins.messagingconnector.CalendarEvent;
import org.ametys.plugins.messagingconnector.EmailMessage;
import org.ametys.plugins.messagingconnector.MessagingConnectorException;
import org.ametys.runtime.config.Config;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ExchangeConnector
extends AbstractMessagingConnector {
    private UserManager _userManager;
    private EWSConnector _ewsConnector;
    private GraphConnector _graphConnector;
    private List<String> _ewsUserDirectoryIds;
    private List<String> _graphUserDirectoryIds;

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._userManager = (UserManager)manager.lookup(UserManager.ROLE);
        this._ewsConnector = (EWSConnector)((Object)manager.lookup(EWSConnector.INNER_ROLE));
        this._graphConnector = (GraphConnector)((Object)manager.lookup(GraphConnector.INNER_ROLE));
    }

    public void initialize() {
        List<String> allowedGraphUserDirectoryIds;
        List<String> allowedExchangeUserDirectoryIds;
        String userDirectoryIdsAsString;
        super.initialize();
        List<String> allowedUserDirectoryIds = null;
        try {
            allowedUserDirectoryIds = this._getAllowedUserDirectoryIds(List.of());
        }
        catch (MessagingConnectorException e) {
            this.getLogger().error("An error occured during computation of allowed user directories", (Throwable)e);
            return;
        }
        this._ewsUserDirectoryIds = new ArrayList<String>();
        this._graphUserDirectoryIds = new ArrayList<String>();
        Boolean ews = (Boolean)Config.getInstance().getValue("org.ametys.plugins.exchange.ews");
        Boolean graph = (Boolean)Config.getInstance().getValue("org.ametys.plugins.exchange.graph");
        if (ews.booleanValue()) {
            userDirectoryIdsAsString = (String)Config.getInstance().getValue("org.ametys.plugins.exchange.ewsuserdirectory");
            this._ewsUserDirectoryIds = this._getUserDirectoryIds(userDirectoryIdsAsString, allowedUserDirectoryIds);
        }
        if (graph.booleanValue()) {
            userDirectoryIdsAsString = (String)Config.getInstance().getValue("org.ametys.plugins.exchange.graphuserdirectory");
            this._graphUserDirectoryIds = this._getUserDirectoryIds(userDirectoryIdsAsString, allowedUserDirectoryIds);
        }
        if (graph.booleanValue() && ews.booleanValue() && CollectionUtils.containsAny(allowedExchangeUserDirectoryIds = this._getAllowedUserDirectoryIds(this._ewsUserDirectoryIds), allowedGraphUserDirectoryIds = this._getAllowedUserDirectoryIds(this._graphUserDirectoryIds))) {
            throw new IllegalStateException("The directory ids defined in Azure application and Exchange Server share same user directory");
        }
    }

    private List<String> _getUserDirectoryIds(String userDirectoryIdsAsString, List<String> allowedUserDirectoryIds) {
        ArrayList<String> ids = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)userDirectoryIdsAsString)) {
            String[] userDirectoryIds = StringUtils.split((String)userDirectoryIdsAsString, (String)",");
            ArrayList<String> wrongUserDirectoryIds = new ArrayList<String>();
            for (String userDirectoryId : userDirectoryIds) {
                String userDirectoryIdTrimed = StringUtils.trim((String)userDirectoryId);
                if (!allowedUserDirectoryIds.contains(userDirectoryIdTrimed)) {
                    wrongUserDirectoryIds.add(userDirectoryIdTrimed);
                    continue;
                }
                ids.add(userDirectoryIdTrimed);
            }
            if (!wrongUserDirectoryIds.isEmpty()) {
                throw new IllegalStateException("The following user directory ids defined in the Exchange configuration do not exist : " + String.valueOf(wrongUserDirectoryIds));
            }
        }
        return ids;
    }

    private List<String> _getAllowedUserDirectoryIds(List<String> userDirectoryIds) {
        if (userDirectoryIds.isEmpty()) {
            List<String> allowedUserDirectoryIds = this.getAllowedPopulationIds().stream().map(populationId -> this._userPopulationDAO.getUserPopulation(populationId)).map(UserPopulation::getUserDirectories).flatMap(Collection::stream).map(UserDirectory::getId).collect(Collectors.toList());
            return allowedUserDirectoryIds;
        }
        return userDirectoryIds;
    }

    private ConnectorType _getConnectorTypeByUserIdentity(UserIdentity userIdentity) {
        User user = this._userManager.getUser(userIdentity);
        UserDirectory userDirectory = user.getUserDirectory();
        String userDirectoryId = userDirectory.getId();
        return this._getConnectorTypeByUserDirectory(userDirectoryId);
    }

    private ConnectorType _getConnectorTypeByUserDirectory(String userDirectoryId) {
        Boolean exchange = (Boolean)Config.getInstance().getValue("org.ametys.plugins.exchange.ews");
        Boolean graph = (Boolean)Config.getInstance().getValue("org.ametys.plugins.exchange.graph");
        if (!exchange.booleanValue() && !graph.booleanValue()) {
            return ConnectorType.NO_CONNECTOR_CONFIGURED;
        }
        if (exchange.booleanValue() && !graph.booleanValue()) {
            return ConnectorType.EXCHANGE_CONNECTOR;
        }
        if (!exchange.booleanValue() && graph.booleanValue()) {
            return ConnectorType.GRAPH_CONNECTOR;
        }
        if (exchange.booleanValue() && graph.booleanValue()) {
            boolean idIsInExchangeList = this._getAllowedUserDirectoryIds(this._ewsUserDirectoryIds).contains(userDirectoryId);
            boolean idIsInGraphList = this._getAllowedUserDirectoryIds(this._graphUserDirectoryIds).contains(userDirectoryId);
            if (idIsInExchangeList && !idIsInGraphList) {
                return ConnectorType.EXCHANGE_CONNECTOR;
            }
            if (!idIsInExchangeList && idIsInGraphList) {
                return ConnectorType.GRAPH_CONNECTOR;
            }
        }
        return ConnectorType.NO_CONNECTOR_ASSIGNED;
    }

    protected List<CalendarEvent> internalGetEvents(UserIdentity userIdentity, int maxDays, int maxEvents) throws MessagingConnectorException {
        switch (this._getConnectorTypeByUserIdentity(userIdentity).ordinal()) {
            case 0: {
                return this._graphConnector.internalGetEvents(userIdentity, maxDays, maxEvents);
            }
            case 1: {
                return this._ewsConnector.internalGetEvents(userIdentity, maxDays, maxEvents);
            }
        }
        throw new MessagingConnectorException("Cannot get events for user " + String.valueOf(userIdentity) + ": user directory is not supported by this messaging connector", MessagingConnectorException.ExceptionType.CONFIGURATION_EXCEPTION);
    }

    protected int internalGetEventsCount(UserIdentity userIdentity, int maxDays) throws MessagingConnectorException {
        switch (this._getConnectorTypeByUserIdentity(userIdentity).ordinal()) {
            case 0: {
                return this._graphConnector.internalGetEventsCount(userIdentity, maxDays);
            }
            case 1: {
                return this._ewsConnector.internalGetEventsCount(userIdentity, maxDays);
            }
        }
        throw new MessagingConnectorException("Cannot get events count for user " + String.valueOf(userIdentity) + ": user directory is not supported by this messaging connector", MessagingConnectorException.ExceptionType.CONFIGURATION_EXCEPTION);
    }

    protected List<EmailMessage> internalGetEmails(UserIdentity userIdentity, int maxEmails) throws MessagingConnectorException {
        switch (this._getConnectorTypeByUserIdentity(userIdentity).ordinal()) {
            case 0: {
                return this._graphConnector.internalGetEmails(userIdentity, maxEmails);
            }
            case 1: {
                return this._ewsConnector.internalGetEmails(userIdentity, maxEmails);
            }
        }
        throw new MessagingConnectorException("Cannot get emails for user " + String.valueOf(userIdentity) + ": user directory is not supported by this messaging connector", MessagingConnectorException.ExceptionType.CONFIGURATION_EXCEPTION);
    }

    protected int internalGetEmailsCount(UserIdentity userIdentity) throws MessagingConnectorException {
        switch (this._getConnectorTypeByUserIdentity(userIdentity).ordinal()) {
            case 0: {
                return this._graphConnector.internalGetEmailsCount(userIdentity);
            }
            case 1: {
                return this._ewsConnector.internalGetEmailsCount(userIdentity);
            }
        }
        throw new MessagingConnectorException("Cannot get emails count for user " + String.valueOf(userIdentity) + ": user directory is not supported by this messaging connector", MessagingConnectorException.ExceptionType.CONFIGURATION_EXCEPTION);
    }

    public boolean supportUserCredential(UserIdentity userIdentity) {
        switch (this._getConnectorTypeByUserIdentity(userIdentity).ordinal()) {
            case 0: {
                return this._graphConnector.supportUserCredential(userIdentity);
            }
            case 1: {
                return this._ewsConnector.supportUserCredential(userIdentity);
            }
        }
        throw new MessagingConnectorException("Cannot get support for credential for user " + String.valueOf(userIdentity) + ": user directory is not supported by this messaging connector", MessagingConnectorException.ExceptionType.CONFIGURATION_EXCEPTION);
    }

    private static enum ConnectorType {
        GRAPH_CONNECTOR,
        EXCHANGE_CONNECTOR,
        NO_CONNECTOR_CONFIGURED,
        NO_CONNECTOR_ASSIGNED;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

