/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.exchange;

import com.microsoft.graph.core.requests.IBaseClient;
import com.microsoft.graph.core.tasks.PageIterator;
import com.microsoft.graph.models.Event;
import com.microsoft.graph.models.EventCollectionResponse;
import com.microsoft.graph.models.MessageCollectionResponse;
import com.microsoft.graph.users.item.UserItemRequestBuilder;
import com.microsoft.kiota.serialization.Parsable;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.util.DateUtils;
import org.ametys.plugins.extrausermgt.graph.GraphClientProvider;
import org.ametys.plugins.messagingconnector.AbstractMessagingConnector;
import org.ametys.plugins.messagingconnector.CalendarEvent;
import org.ametys.plugins.messagingconnector.EmailMessage;
import org.ametys.plugins.messagingconnector.MessagingConnectorException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public class GraphConnector
extends AbstractMessagingConnector {
    public static final String INNER_ROLE = GraphConnector.class.getName();
    protected GraphClientProvider _graphClientProvider;

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._graphClientProvider = (GraphClientProvider)manager.lookup(GraphClientProvider.ROLE);
    }

    private List<Event> _getEvents(UserIdentity userIdentity, int maxDays) {
        try {
            UserItemRequestBuilder userRequestBuilder = this._graphClientProvider.getUserRequestBuilder(userIdentity);
            ZonedDateTime now = ZonedDateTime.now(ZoneOffset.UTC).truncatedTo(ChronoUnit.SECONDS);
            String start = now.format(DateTimeFormatter.ISO_DATE_TIME);
            String end = now.plusDays(maxDays).format(DateTimeFormatter.ISO_DATE_TIME);
            ArrayList<Event> result = new ArrayList<Event>();
            EventCollectionResponse eventCollectionResponse = userRequestBuilder.calendar().calendarView().get(requestConfiguration -> {
                requestConfiguration.queryParameters.startDateTime = start;
                requestConfiguration.queryParameters.endDateTime = end;
                requestConfiguration.queryParameters.orderby = new String[]{"start/datetime"};
                requestConfiguration.queryParameters.select = new String[]{"subject", "start", "end", "location"};
            });
            new PageIterator.Builder().client((IBaseClient)this._graphClientProvider.getGraphClient()).collectionPage((Parsable)eventCollectionResponse).collectionPageFactory(EventCollectionResponse::createFromDiscriminatorValue).processPageItemCallback(event -> {
                result.add((Event)event);
                return true;
            }).build().iterate();
            return result;
        }
        catch (GraphClientProvider.GraphClientException e) {
            throw new MessagingConnectorException("Failed to retrieve a Graph client for user " + String.valueOf(userIdentity) + ". The user could not be linked to a Entra user", MessagingConnectorException.ExceptionType.UNAUTHORIZED, (Throwable)e);
        }
        catch (Exception e) {
            throw new MessagingConnectorException("An error occured while contacting the graph endpoint for user " + String.valueOf(userIdentity), MessagingConnectorException.ExceptionType.UNKNOWN, (Throwable)e);
        }
    }

    protected List<CalendarEvent> internalGetEvents(UserIdentity userIdentity, int maxDays, int maxEvents) throws MessagingConnectorException {
        List<Event> events = this._getEvents(userIdentity, maxDays);
        TreeMap<Long, CalendarEvent> calendarEvents = new TreeMap<Long, CalendarEvent>();
        for (Event event : events) {
            LocalDateTime ldt = LocalDateTime.parse(event.getStart().getDateTime(), DateTimeFormatter.ISO_DATE_TIME);
            ZonedDateTime zdt = ldt.atZone(ZoneId.of(event.getStart().getTimeZone()));
            zdt = zdt.withZoneSameInstant(ZoneId.systemDefault());
            long longStart = zdt.toEpochSecond();
            Date startDate = DateUtils.asDate((ZonedDateTime)zdt);
            ldt = LocalDateTime.parse(event.getEnd().getDateTime(), DateTimeFormatter.ISO_DATE_TIME);
            zdt = ldt.atZone(ZoneId.of(event.getEnd().getTimeZone()));
            zdt = zdt.withZoneSameInstant(ZoneId.systemDefault());
            Date endDate = DateUtils.asDate((ZonedDateTime)zdt);
            CalendarEvent newEvent = new CalendarEvent();
            newEvent.setStartDate(startDate);
            newEvent.setEndDate(endDate);
            newEvent.setSubject(event.getSubject());
            newEvent.setLocation(event.getLocation().getDisplayName());
            calendarEvents.put(longStart, newEvent);
        }
        return calendarEvents.entrySet().stream().limit(maxEvents).map(e -> (CalendarEvent)e.getValue()).collect(Collectors.toList());
    }

    protected int internalGetEventsCount(UserIdentity userIdentity, int maxDays) throws MessagingConnectorException {
        return this._getEvents(userIdentity, maxDays).size();
    }

    protected List<EmailMessage> internalGetEmails(UserIdentity userIdentity, int maxEmails) throws MessagingConnectorException {
        try {
            UserItemRequestBuilder userRequestBuilder = this._graphClientProvider.getUserRequestBuilder(userIdentity);
            MessageCollectionResponse messageCollectionResponse = userRequestBuilder.mailFolders().byMailFolderId("inbox").messages().get(requestConfiguration -> {
                requestConfiguration.queryParameters.top = Math.min(maxEmails, 999);
                requestConfiguration.queryParameters.select = new String[]{"sender", "subject", "bodyPreview"};
                requestConfiguration.queryParameters.filter = "isRead eq false";
            });
            ArrayList<EmailMessage> result = new ArrayList<EmailMessage>();
            new PageIterator.Builder().client((IBaseClient)this._graphClientProvider.getGraphClient()).collectionPage((Parsable)messageCollectionResponse).collectionPageFactory(MessageCollectionResponse::createFromDiscriminatorValue).processPageItemCallback(message -> {
                result.add(new EmailMessage(message.getSubject(), message.getSender().getEmailAddress().getAddress(), message.getBodyPreview()));
                return result.size() < maxEmails;
            }).build().iterate();
            return result;
        }
        catch (GraphClientProvider.GraphClientException e) {
            throw new MessagingConnectorException("Failed to retrieve a Graph client for user " + String.valueOf(userIdentity) + ". The user could not be linked to a Entra user", MessagingConnectorException.ExceptionType.UNAUTHORIZED, (Throwable)e);
        }
        catch (Exception e) {
            throw new MessagingConnectorException("An error occured while contacting the graph endpoint for user " + String.valueOf(userIdentity), MessagingConnectorException.ExceptionType.UNKNOWN, (Throwable)e);
        }
    }

    protected int internalGetEmailsCount(UserIdentity userIdentity) throws MessagingConnectorException {
        try {
            UserItemRequestBuilder userRequestBuilder = this._graphClientProvider.getUserRequestBuilder(userIdentity);
            return userRequestBuilder.mailFolders().byMailFolderId("inbox").get().getUnreadItemCount();
        }
        catch (GraphClientProvider.GraphClientException e) {
            throw new MessagingConnectorException("Failed to retrieve a Graph client for user " + String.valueOf(userIdentity) + ". The user could not be linked to a Entra user", MessagingConnectorException.ExceptionType.UNAUTHORIZED, (Throwable)e);
        }
    }
}

