/*
 *  Copyright 2024 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

let config = "ametys-home://config/config.xml";

Ametys.utils.searchAndReplace(config,
    /(org.ametys.plugins.exchange.useadmin)/g,
    'org.ametys.plugins.extra-user-management.graph.useadmin');
Ametys.utils.searchAndReplace(config, 
    /(org.ametys.plugins.exchange.appid)/g,
    'org.ametys.plugins.extra-user-management.graph.appid');
Ametys.utils.searchAndReplace(config, 
    /(org.ametys.plugins.exchange.tenant)/g,
    'org.ametys.plugins.extra-user-management.graph.tenant');
Ametys.utils.searchAndReplace(config, 
    /(org.ametys.plugins.exchange.clientsecret)/g,
    'org.ametys.plugins.extra-user-management.graph.clientsecret');
Ametys.utils.searchAndReplace(config, 
    /(org.ametys.plugins.exchange.authmethodgraph)/g,
    'org.ametys.plugins.extra-user-management.graph.authmethod');
Ametys.utils.searchAndReplace(config, 
    /(plugin.exchange:PLUGINS_EXCHANGE_GRAPH_GROUP)/g,
    'plugin.extra-user-management:PLUGINS_EXTUSERMGT_GRAPH_GROUP');

logger.info("Migration needs a restart of the application");
actionData.setRequiresRestart(true);
