/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.externaldata.data.jcr;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.ametys.core.datasource.DataSourceClientInteraction;
import org.ametys.core.observation.Event;
import org.ametys.core.observation.ObservationManager;
import org.ametys.core.ui.Callable;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.plugins.externaldata.data.DataInclusionException;
import org.ametys.plugins.externaldata.data.DataSourceFactory;
import org.ametys.plugins.externaldata.data.DataSourceFactoryExtensionPoint;
import org.ametys.plugins.externaldata.data.Query;
import org.ametys.plugins.externaldata.data.QueryDao;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.ModifiableTraversableAmetysObject;
import org.ametys.plugins.repository.jcr.JCRAmetysObject;
import org.ametys.plugins.repository.jcr.NameHelper;
import org.ametys.web.repository.site.SiteManager;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.StringUtils;

public class JcrQueryDao
extends AbstractLogEnabled
implements QueryDao,
Serviceable,
Component {
    public static final String ROOT_REPO = "ametys:root";
    public static final String PLUGINS_NODE = "ametys-internal:plugins";
    public static final String PLUGIN_NODE = "external-data";
    public static final String DATASOURCES_NODE = "ametys:datasources";
    public static final String QUERIES_NODE = "ametys:queries";
    public static final String PROPERTY_NAME = "ametys:name";
    public static final String PROPERTY_DESCRIPTION = "ametys:description";
    public static final String PROPERTY_TYPE = "ametys:type";
    public static final String PROPERTY_DATASOURCE = "ametys:dataSourceId";
    public static final String PROPERTY_CONF_PREFIX = "ametys:conf-";
    public static final String QUERY_PROPERTY_QUERYSTRING = "ametys:queryString";
    public static final String QUERY_PROPERTY_PARAMETERS = "ametys:parameters";
    public static final String QUERY_PROPERTY_RESULTTYPE = "ametys:resultType";
    protected DataSourceFactoryExtensionPoint _dataSourceFactoryEP;
    protected Repository _repository;
    protected SiteManager _siteManager;
    protected CurrentUserProvider _currentUserProvider;
    protected ObservationManager _observationManager;

    public void service(ServiceManager serviceManager) throws ServiceException {
        this._dataSourceFactoryEP = (DataSourceFactoryExtensionPoint)((Object)serviceManager.lookup(DataSourceFactoryExtensionPoint.ROLE));
        this._repository = (Repository)serviceManager.lookup("javax.jcr.Repository");
        this._siteManager = (SiteManager)serviceManager.lookup(SiteManager.ROLE);
        this._currentUserProvider = (CurrentUserProvider)serviceManager.lookup(CurrentUserProvider.ROLE);
        this._observationManager = (ObservationManager)serviceManager.lookup(ObservationManager.ROLE);
    }

    @Override
    public Map<String, Query> getQueries(String siteName) throws DataInclusionException {
        try {
            HashMap<String, Query> queries = new HashMap<String, Query>();
            Node queriesNode = this._getQueriesNode(siteName);
            NodeIterator queryNodes = queriesNode.getNodes();
            while (queryNodes.hasNext()) {
                Node node = queryNodes.nextNode();
                Query query = this._extractQuery(node);
                queries.put(query.getId(), query);
            }
            return queries;
        }
        catch (RepositoryException e) {
            throw new DataInclusionException("Error getting the data sources", e);
        }
    }

    @Override
    public Map<String, Query> getQueries(String siteName, DataSourceClientInteraction.DataSourceType type) throws DataInclusionException {
        return this.getDataSourceQueries(siteName, null, type, null);
    }

    @Override
    public Map<String, Query> getDataSourceQueries(String siteName, String dataSourceId) throws DataInclusionException {
        return this.getDataSourceQueries(siteName, dataSourceId, null);
    }

    @Override
    public Map<String, Query> getDataSourceQueries(String siteName, String dataSourceId, Query.ResultType resultType) throws DataInclusionException {
        return this.getDataSourceQueries(siteName, dataSourceId, null, resultType);
    }

    @Override
    public Map<String, Query> getDataSourceQueries(String siteName, String dataSourceId, DataSourceClientInteraction.DataSourceType dataSourceType, Query.ResultType resultType) throws DataInclusionException {
        try {
            HashMap<String, Query> queries = new HashMap<String, Query>();
            Node queriesNode = this._getQueriesNode(siteName);
            NodeIterator queryNodes = queriesNode.getNodes();
            while (queryNodes.hasNext()) {
                Node node = queryNodes.nextNode();
                Query query = this._extractQuery(node);
                if (!this._matchQuery(query, dataSourceId, dataSourceType, resultType)) continue;
                queries.put(query.getId(), query);
            }
            return queries;
        }
        catch (RepositoryException e) {
            throw new DataInclusionException("Error getting the data sources", e);
        }
    }

    private boolean _matchQuery(Query query, String dataSourceId, DataSourceClientInteraction.DataSourceType dsType, Query.ResultType resultType) {
        return !(dataSourceId != null && !query.getDataSourceId().equals(dataSourceId) || dsType != null && !query.getType().equals((Object)dsType) || resultType != null && !resultType.equals((Object)query.getResultType()));
    }

    @Override
    public Query getQuery(String siteName, String id) throws DataInclusionException {
        try {
            Query query = null;
            Node queriesNode = this._getQueriesNode(siteName);
            if (queriesNode.hasNode(id)) {
                Node node = queriesNode.getNode(id);
                query = this._extractQuery(node);
            }
            return query;
        }
        catch (RepositoryException e) {
            throw new DataInclusionException("Error getting the data source of id " + id, e);
        }
    }

    @Override
    @Callable(rights={"Datainclusion_Right_Content_InsertQuery", "Datainclusion_Right_Manage"}, context="/cms")
    public Map<String, Object> getQueryProperties(String id, String siteName) throws DataInclusionException {
        HashMap<String, Object> infos = new HashMap<String, Object>();
        Query query = this.getQuery(siteName, id);
        if (query != null) {
            infos.put("id", query.getId());
            infos.put("name", query.getName());
            infos.put("description", query.getDescription());
            infos.put("type", query.getType());
            infos.put("resultType", query.getResultType().name());
            Map<String, String> additionalConf = query.getAdditionalConfiguration();
            for (String confName : additionalConf.keySet()) {
                String value = additionalConf.get(confName);
                if (value == null) continue;
                infos.put(confName, value);
            }
            infos.put("parameters", query.getParameters());
            infos.put("dataSourceId", query.getDataSourceId());
        }
        return infos;
    }

    @Override
    @Callable(rights={"Datainclusion_Right_Manage"}, context="/cms")
    public Map<String, String> addQuery(String siteName, Map<String, Object> parameters) throws Exception {
        HashMap<String, String> result = new HashMap<String, String>();
        String type = (String)parameters.get("type");
        String name = (String)parameters.get("name");
        String description = (String)parameters.get("description");
        String resultTypeStr = (String)parameters.get("resultType");
        Query.ResultType resultType = this._getResultType(resultTypeStr, Query.ResultType.MULTIPLE);
        String dataSourceId = (String)parameters.get("dataSourceId");
        DataSourceFactory factory = this._dataSourceFactoryEP.getFactory(DataSourceClientInteraction.DataSourceType.valueOf((String)type));
        if (factory == null) {
            this.getLogger().error("Impossible to get a factory to handle the type : " + type);
            result.put("error", "unknown-type");
            return result;
        }
        Collection<String> params = factory.getQueryConfigurationParameters(type);
        HashMap<String, String> additionalConfiguration = new HashMap<String, String>();
        for (String paramName : params) {
            String value = (String)parameters.get(paramName);
            if (value == null) continue;
            additionalConfiguration.put(paramName, value);
        }
        try {
            Object query = factory.buildQuery(null, type, name, description, resultType, dataSourceId, additionalConfiguration);
            String id = this.addQuery(siteName, (Query)query);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Query created : got id " + id);
            }
            result.put("id", id);
            result.put("parentId", dataSourceId);
            result.put("type", type);
        }
        catch (DataInclusionException e) {
            this.getLogger().error("Error saving the query", (Throwable)e);
            result.put("error", "add-query-error");
        }
        return result;
    }

    @Override
    public String addQuery(String siteName, Query query) throws DataInclusionException {
        try {
            Node queriesNode = this._getQueriesNode(siteName);
            String name = query.getName();
            if (StringUtils.isBlank((CharSequence)name)) {
                throw new DataInclusionException("Query name can't be blank.");
            }
            String nodeName = NameHelper.filterName((String)name);
            String notExistingNodeName = this._getNotExistingNodeName(queriesNode, nodeName);
            Node node = queriesNode.addNode(notExistingNodeName);
            String id = node.getName();
            node.addMixin("mix:referenceable");
            this._fillQueryNode(query, node);
            queriesNode.getSession().save();
            return id;
        }
        catch (RepositoryException e) {
            throw new DataInclusionException("Error adding a Query", e);
        }
    }

    @Override
    @Callable(rights={"Datainclusion_Right_Manage"}, context="/cms")
    public Map<String, String> updateQuery(String siteName, Map<String, Object> parameters) throws Exception {
        HashMap<String, String> result = new HashMap<String, String>();
        String id = (String)parameters.get("id");
        String type = (String)parameters.get("type");
        String name = (String)parameters.get("name");
        String description = (String)parameters.get("description");
        String resultTypeStr = (String)parameters.get("resultType");
        Query.ResultType resultType = this._getResultType(resultTypeStr, Query.ResultType.MULTIPLE);
        DataSourceFactory factory = this._dataSourceFactoryEP.getFactory(DataSourceClientInteraction.DataSourceType.valueOf((String)type));
        Collection<String> params = factory.getQueryConfigurationParameters(type);
        HashMap<String, String> additionalConfiguration = new HashMap<String, String>();
        for (String paramName : params) {
            String value = (String)parameters.get(paramName);
            if (value == null) continue;
            additionalConfiguration.put(paramName, value);
        }
        try {
            Object query = factory.buildQuery(id, type, name, description, resultType, null, additionalConfiguration);
            this.updateQuery(siteName, (Query)query);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Query updated : id " + query.getId());
            }
            HashMap<String, String> eventParams = new HashMap<String, String>();
            eventParams.put("query.id", query.getId());
            this._observationManager.notify(new Event("query.updated", this._currentUserProvider.getUser(), eventParams));
            result.put("id", id);
            result.put("type", type);
        }
        catch (DataInclusionException e) {
            this.getLogger().error("Error updating the query", (Throwable)e);
            result.put("error", "update-query-error");
        }
        return result;
    }

    @Override
    public void updateQuery(String siteName, Query query) throws DataInclusionException {
        String id = query.getId();
        try {
            Node queriesNode = this._getQueriesNode(siteName);
            if (!queriesNode.hasNode(id)) {
                throw new DataInclusionException("No query exists with id " + id);
            }
            Node node = queriesNode.getNode(id);
            String name = query.getName();
            if (StringUtils.isBlank((CharSequence)name)) {
                throw new DataInclusionException("Name can't be blank.");
            }
            this._fillQueryNode(query, node);
            node.getSession().save();
        }
        catch (RepositoryException e) {
            throw new DataInclusionException("Error updating the Data Source of id " + id, e);
        }
    }

    @Override
    @Callable(rights={"Datainclusion_Right_Manage"}, context="/cms")
    public Map<String, String> deleteQuery(String siteName, String id) throws Exception {
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            this.removeQuery(siteName, id);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Query id " + id + " deleted.");
            }
            HashMap<String, String> eventParams = new HashMap<String, String>();
            eventParams.put("query.id", id);
            this._observationManager.notify(new Event("query.deleted", this._currentUserProvider.getUser(), eventParams));
            result.put("id", id);
        }
        catch (DataInclusionException e) {
            this.getLogger().error("Error deleting the query", (Throwable)e);
            result.put("error", "delete-query-error");
        }
        return result;
    }

    @Override
    public void removeQuery(String siteName, String id) throws DataInclusionException {
        try {
            Node queriesNode = this._getQueriesNode(siteName);
            if (!queriesNode.hasNode(id)) {
                throw new DataInclusionException("No data source exists with id " + id);
            }
            queriesNode.getNode(id).remove();
            queriesNode.getSession().save();
        }
        catch (RepositoryException e) {
            throw new DataInclusionException("Error updating the Data Source of id " + id, e);
        }
    }

    protected Query _extractQuery(Node node) throws RepositoryException, DataInclusionException {
        Query query = null;
        String id = node.getName();
        String type = this._getSingleProperty(node, PROPERTY_TYPE, "");
        String name = this._getSingleProperty(node, PROPERTY_NAME, "");
        String description = this._getSingleProperty(node, PROPERTY_DESCRIPTION, "");
        Query.ResultType resultType = this._getResultType(node, Query.ResultType.MULTIPLE);
        String dataSourceId = this._getSingleProperty(node, PROPERTY_DATASOURCE, "");
        Map<String, String> additionalConf = this._getAdditionalConf(node);
        DataSourceFactory factory = this._dataSourceFactoryEP.getFactory(DataSourceClientInteraction.DataSourceType.valueOf((String)type));
        if (factory == null) {
            throw new DataInclusionException("Unknown query type.");
        }
        query = (Query)factory.buildQuery(id, type, name, description, resultType, dataSourceId, additionalConf);
        return query;
    }

    protected String _getSingleProperty(Node node, String propertyName, String defaultValue) throws RepositoryException {
        String value = defaultValue;
        if (node.hasProperty(propertyName)) {
            value = node.getProperty(propertyName).getString();
        }
        return value;
    }

    protected Query.ResultType _getResultType(String value, Query.ResultType defaultValue) throws RepositoryException {
        Query.ResultType result = defaultValue;
        try {
            result = Query.ResultType.valueOf(value);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    protected Query.ResultType _getResultType(Node node, Query.ResultType defaultValue) throws RepositoryException {
        Query.ResultType result = defaultValue;
        if (node.hasProperty(QUERY_PROPERTY_RESULTTYPE)) {
            String value = node.getProperty(QUERY_PROPERTY_RESULTTYPE).getString();
            try {
                result = Query.ResultType.valueOf(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    protected Collection<String> _getMultipleProperty(Node node, String propertyName) throws RepositoryException {
        ArrayList<String> values = new ArrayList<String>();
        if (node.hasProperty(propertyName)) {
            Value[] propertyValues;
            for (Value value : propertyValues = node.getProperty(propertyName).getValues()) {
                values.add(value.getString());
            }
        }
        return values;
    }

    protected Map<String, String> _getAdditionalConf(Node node) throws RepositoryException {
        HashMap<String, String> values = new HashMap<String, String>();
        PropertyIterator propertyIt = node.getProperties("ametys:conf-*");
        while (propertyIt.hasNext()) {
            Property property = propertyIt.nextProperty();
            String propName = property.getName();
            String name = propName.substring(PROPERTY_CONF_PREFIX.length(), propName.length());
            String value = property.getString();
            values.put(name, value);
        }
        return values;
    }

    protected void _fillQueryNode(Query query, Node node) throws RepositoryException {
        node.setProperty(PROPERTY_NAME, query.getName());
        node.setProperty(PROPERTY_DESCRIPTION, query.getDescription());
        node.setProperty(PROPERTY_TYPE, query.getType().name());
        node.setProperty(QUERY_PROPERTY_RESULTTYPE, query.getResultType().name());
        if (query.getDataSourceId() != null) {
            node.setProperty(PROPERTY_DATASOURCE, query.getDataSourceId());
        }
        Map<String, String> additionalConf = query.getAdditionalConfiguration();
        for (String confName : additionalConf.keySet()) {
            String value = additionalConf.get(confName);
            node.setProperty(PROPERTY_CONF_PREFIX + confName, value);
        }
    }

    protected String _getNotExistingNodeName(Node container, String baseName) throws RepositoryException {
        Object name = baseName;
        int index = 2;
        while (container.hasNode((String)name)) {
            name = baseName + index;
            ++index;
        }
        return name;
    }

    protected Node _getPluginNode(String siteName) throws RepositoryException {
        Session session = null;
        try {
            Node pluginNode;
            session = this._repository.login();
            ModifiableTraversableAmetysObject rootPlugins = this._siteManager.getSite(siteName).getRootPlugins();
            Node pluginsNode = ((JCRAmetysObject)rootPlugins).getNode();
            if (pluginsNode.hasNode(PLUGIN_NODE)) {
                pluginNode = pluginsNode.getNode(PLUGIN_NODE);
            } else {
                pluginNode = pluginsNode.addNode(PLUGIN_NODE);
                pluginsNode.getSession().save();
            }
            return pluginNode;
        }
        catch (PathNotFoundException e) {
            if (session != null) {
                session.logout();
            }
            throw new AmetysRepositoryException("Unable to get site plugins node for site " + siteName, (Throwable)e);
        }
        catch (RepositoryException e) {
            if (session != null) {
                session.logout();
            }
            throw new AmetysRepositoryException("An error occured while getting site plugins node for site " + siteName, (Throwable)e);
        }
    }

    protected Node _getQueriesNode(String siteName) throws RepositoryException {
        try {
            Node node;
            Node pluginNode = this._getPluginNode(siteName);
            if (pluginNode.hasNode(QUERIES_NODE)) {
                node = pluginNode.getNode(QUERIES_NODE);
            } else {
                node = pluginNode.addNode(QUERIES_NODE);
                pluginNode.getSession().save();
            }
            return node;
        }
        catch (PathNotFoundException e) {
            throw new AmetysRepositoryException("Unable to get queries node because it doesn't exist.", (Throwable)e);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("An error occured while getting queries node.", (Throwable)e);
        }
    }
}

