/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.externaldata.data.ldap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.naming.directory.SearchControls;
import org.ametys.core.datasource.DataSourceClientInteraction;
import org.ametys.core.util.ldap.AbstractLDAPConnector;
import org.ametys.core.util.ldap.ScopeEnumerator;
import org.ametys.plugins.externaldata.data.DataInclusionException;
import org.ametys.plugins.externaldata.data.DataSourceFactory;
import org.ametys.plugins.externaldata.data.Query;
import org.ametys.plugins.externaldata.data.ldap.LdapQuery;
import org.ametys.plugins.externaldata.data.ldap.LdapQueryResult;
import org.ametys.runtime.plugin.component.PluginAware;
import org.apache.commons.lang3.StringUtils;

public class LdapDataSourceFactory
extends AbstractLDAPConnector
implements DataSourceFactory<LdapQuery, LdapQueryResult>,
PluginAware {
    public static final String QUERY_CONFIGURATION_RELATIVE_DN = "relativeDN";
    public static final String QUERY_CONFIGURATION_SCOPE = "scope";
    public static final String QUERY_CONFIGURATION_ATTRIBUTES = "attributes";
    public static final String QUERY_CONFIGURATION_CONSTRAINT = "constraint";
    public static final List<String> QUERY_CONFIGURATION_PARAMETERS = Arrays.asList("relativeDN", "scope", "attributes", "constraint");
    private String _id;

    public void setPluginInfo(String pluginName, String featureName, String id) {
        this._id = id;
    }

    @Override
    public Collection<DataSourceClientInteraction.DataSourceType> getHandledTypes() {
        return Collections.singleton(DataSourceClientInteraction.DataSourceType.LDAP);
    }

    @Override
    public Collection<String> getQueryConfigurationParameters(String type) {
        return QUERY_CONFIGURATION_PARAMETERS;
    }

    @Override
    public LdapQuery buildQuery(String id, String type, String name, String description, Query.ResultType resultType, String dataSourceId, Map<String, String> additionalConfiguration) throws DataInclusionException {
        String relativeDN = StringUtils.defaultString((String)additionalConfiguration.get(QUERY_CONFIGURATION_RELATIVE_DN));
        String attributes = StringUtils.defaultString((String)additionalConfiguration.get(QUERY_CONFIGURATION_ATTRIBUTES));
        String constraint = StringUtils.defaultString((String)additionalConfiguration.get(QUERY_CONFIGURATION_CONSTRAINT));
        String scope = StringUtils.defaultString((String)additionalConfiguration.get(QUERY_CONFIGURATION_SCOPE));
        LdapQuery query = new LdapQuery();
        query.setId(id);
        query.setFactory(this._id);
        query.setName(name);
        query.setDescription(description);
        query.setResultType(resultType);
        query.setDataSourceId(dataSourceId);
        query.setRelativeDN(relativeDN);
        query.setAttributes(attributes);
        query.setConstraint(constraint);
        query.setScope(scope);
        return query;
    }

    @Override
    public LdapQueryResult execute(LdapQuery query, Map<String, String> parameterValues) throws DataInclusionException {
        return this.execute(query, parameterValues, 0, Integer.MAX_VALUE);
    }

    @Override
    public LdapQueryResult execute(LdapQuery query, Map<String, String> parameterValues, int offset, int limit) throws DataInclusionException {
        List results = null;
        try {
            String dataSourceId = query.getDataSourceId();
            this._delayedInitialize(dataSourceId);
            Map<String, String> attributeMap = query.getAttributesAsMap();
            int paramCount = query.getParameters().size();
            Object[] values = new Object[paramCount];
            int paramIndex = 0;
            String constraint = query.getConstraint();
            for (String paramName : query.getParameters().keySet()) {
                if (parameterValues.containsKey(paramName)) {
                    constraint = constraint.replaceAll("\\$\\{" + paramName + "(\\[[^\\]]*\\])?\\}", "{" + paramIndex + "}");
                    values[paramIndex] = parameterValues.get(paramName);
                    ++paramIndex;
                    continue;
                }
                String regexp = "\\([^()=,\\s]*=[^$()]*\\$\\{" + paramName + "(\\[[^\\]]*\\])?\\}[^\\)]*\\)";
                constraint = constraint.replaceAll(regexp, "");
            }
            StringBuilder filter = new StringBuilder();
            if (StringUtils.isNotBlank((CharSequence)constraint)) {
                filter.append(constraint);
            }
            ArrayList<String> columnLabels = new ArrayList<String>(attributeMap.keySet());
            SearchControls controls = this._getSearchControls(attributeMap.values(), query.getScope());
            results = this._search(query.getRelativeDN(), filter.toString(), values, controls, offset, limit);
            LdapQueryResult queryResult = new LdapQueryResult(results, columnLabels, attributeMap);
            return queryResult;
        }
        catch (Exception e) {
            throw new DataInclusionException("Unable to execute the LDAP query.", e);
        }
    }

    protected SearchControls _getSearchControls(Collection<String> attributes, String scopeStr) throws DataInclusionException {
        SearchControls controls = new SearchControls();
        String[] attrArray = attributes.toArray(new String[attributes.size()]);
        controls.setReturningAttributes(attrArray);
        controls.setSearchScope(this._getScope(scopeStr));
        return controls;
    }

    protected int _getScope(String scopeStr) throws DataInclusionException {
        try {
            return ScopeEnumerator.parseScope((String)scopeStr);
        }
        catch (IllegalArgumentException e) {
            throw new DataInclusionException("Unable to parse scope", e);
        }
    }
}

