/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.externaldata.data.ldap;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ametys.core.datasource.DataSourceClientInteraction;
import org.ametys.plugins.externaldata.data.AbstractQuery;
import org.apache.commons.lang3.StringUtils;

public class LdapQuery
extends AbstractQuery {
    public static final String ATTRIBUTE_PATTERN = "(\\w+)(?:\\[([^\\]]+)\\])?";
    public static final Pattern ATTRIBUTE_MATCHER = Pattern.compile("(\\w+)(?:\\[([^\\]]+)\\])?");
    protected String _attributes;
    protected String _constraint;
    protected String _relativeDN;
    protected String _scope;
    protected Map<String, String> _attributeMap;

    @Override
    public DataSourceClientInteraction.DataSourceType getType() {
        return DataSourceClientInteraction.DataSourceType.LDAP;
    }

    public String getAttributes() {
        return this._attributes;
    }

    public void setAttributes(String attributes) {
        this._attributes = attributes;
    }

    public String getConstraint() {
        return this._constraint;
    }

    public void setConstraint(String constraint) {
        this._constraint = constraint;
    }

    public void setRelativeDN(String relativeDN) {
        this._relativeDN = relativeDN;
    }

    public String getRelativeDN() {
        return this._relativeDN;
    }

    public String getScope() {
        return this._scope;
    }

    public void setScope(String scope) {
        this._scope = scope;
    }

    @Override
    public Map<String, String> getParameters() {
        if (this._parameters == null) {
            this._parameters = this._buildParameters(this._constraint);
        }
        return this._parameters;
    }

    @Override
    public Map<String, String> getAdditionalConfiguration() {
        HashMap<String, String> additionalConf = new HashMap<String, String>();
        additionalConf.put("attributes", this._attributes);
        additionalConf.put("constraint", this._constraint);
        additionalConf.put("scope", this._scope);
        additionalConf.put("relativeDN", this._relativeDN);
        return additionalConf;
    }

    public Map<String, String> getAttributesAsMap() {
        if (this._attributeMap == null) {
            this._attributeMap = this._buildAttributesMap(this._attributes);
        }
        return this._attributeMap;
    }

    protected Map<String, String> _buildAttributesMap(String query) {
        LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
        if (query != null) {
            String[] attributeArray;
            for (String attribute : attributeArray = query.split(",")) {
                String attributeTrimmed = attribute.trim();
                Matcher matcher = ATTRIBUTE_MATCHER.matcher(attributeTrimmed);
                while (matcher.find()) {
                    String attrName;
                    if (matcher.groupCount() == 1) {
                        attrName = matcher.group(1);
                        attributes.put(attrName, attrName);
                        continue;
                    }
                    if (matcher.groupCount() <= 1) continue;
                    attrName = matcher.group(1);
                    String attrLabel = matcher.group(2);
                    if (StringUtils.isBlank((CharSequence)attrLabel)) {
                        attrLabel = attrName;
                    }
                    attributes.put(attrLabel, attrName);
                }
            }
        }
        return attributes;
    }
}

