/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.externaldata.data;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

import org.ametys.core.datasource.DataSourceClientInteraction.DataSourceType;
import org.ametys.runtime.plugin.component.AbstractThreadSafeComponentExtensionPoint;

/**
 * Extension point for DataSource factories.
 */
public class DataSourceFactoryExtensionPoint extends AbstractThreadSafeComponentExtensionPoint<DataSourceFactory>
{
    
    /** The Avalon role. */
    public static final String ROLE = DataSourceFactoryExtensionPoint.class.getName();
    
    /**
     * Get all types handled by the various declared factories.
     * @return the types as a Collection.
     */
    public Collection<DataSourceType> getAllTypes()
    {
        Set<DataSourceType> types = new HashSet<>();
        for (String extensionId : getExtensionsIds())
        {
            DataSourceFactory extensionFactory = getExtension(extensionId);
            types.addAll(extensionFactory.getHandledTypes());
        }
        return types;
    }
    
    /**
     * Get the factory handling the specified type.
     * @param type the data source type.
     * @return the DataSourceFactory handling the specified type, null if no factory handles this type.
     */
    public DataSourceFactory getFactory(DataSourceType type)
    {
        for (String extensionId : getExtensionsIds())
        {
            DataSourceFactory extensionFactory = getExtension(extensionId);
            if (extensionFactory.getHandledTypes().contains(type))
            {
                return extensionFactory;
            }
        }
        return null;
    }
    
}
