/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.externaldata.data;

import java.util.Collection;

import org.ametys.plugins.externaldata.data.Query.ResultType;

/**
 * Result of a Query. Can be either single (should have one column and one row),
 * or multiple (one or more columns, one or more rows).
 */
public interface QueryResult extends Iterable<QueryResultRow>
{
    
    /**
     * Get the type of the result.
     * @return the result type.
     */
    ResultType getType();
    
    /**
     * Get size
     * @return the size
     */
    int getSize();
    
    /**
     * Get the column names.
     * @return the column names as a Collection.
     * @throws DataInclusionException if an error occurs while manipulating the data sources
     */
    Collection<String> getColumnNames() throws DataInclusionException;
    
    /**
     * Close and cleanup the underlying objects and resources (resultset if SQL, LDAP resources...) if needed.
     */
    void close();
}
