/*
 *  Copyright 2024 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.extrausermgt.proxy;

import org.apache.cocoon.environment.Request;
import org.apache.http.client.methods.HttpUriRequest;
import org.slf4j.Logger;

import org.ametys.core.authentication.CredentialProvider;
import org.ametys.plugins.extrausermgt.authentication.msal.AbstractMSALCredentialProvider;
import org.ametys.plugins.site.proxy.SessionAttributeRequestProxy;
import org.ametys.runtime.plugin.component.LogEnabled;
import org.ametys.site.FrontAuthenticateAction;

/**
 * Request proxy to forward the MS authentication token to the back office.
 * If needed, the token is refreshed before the forward
 */
public class MSALSessionAttributeRequestProxy extends SessionAttributeRequestProxy implements LogEnabled
{
    // FIXME make SessionAttributeRequestProxy extends AbstractLogEnabled
    private Logger _logger;

    /**
     * Returns the {@link Logger}.
     * @return the {@link Logger}.
     */
    // FIXME make SessionAttributeRequestProxy extends AbstractLogEnabled
    protected Logger getLogger()
    {
        return _logger;
    }

    // FIXME make SessionAttributeRequestProxy extends AbstractLogEnabled
    public void setLogger(Logger logger)
    {
        _logger = logger;
    }

    @Override
    public void prepareBackOfficeRequest(Request request, HttpUriRequest backOfficeRequest)
    {
        CredentialProvider credentialProvider = FrontAuthenticateAction.getCredentialProviderFromSession(request);
        if (credentialProvider instanceof AbstractMSALCredentialProvider msalCP)
        {
            try
            {
                msalCP.refreshTokenIfNeeded(request.getSession());
                super.prepareBackOfficeRequest(request, backOfficeRequest);
            }
            catch (Exception e)
            {
                getLogger().warn("An error prevented refreshing the token before forwaring it to the back office. See previous exception for more details", e);
            }
        }
    }
}
