/*
 *  Copyright 2023 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.extrausermgt.proxy;

import java.util.Set;

import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

import org.ametys.plugins.extrausermgt.oauth.DefaultOauthProvider;
import org.ametys.plugins.extrausermgt.oauth.OAuthProvider;
import org.ametys.plugins.extrausermgt.oauth.OauthProviderExtensionPoint;
import org.ametys.plugins.site.proxy.SessionAttributeRequestProxy;

/**
 * Define the list of session attribute to proxy to the front for all the defined Oauth providers
 */
public class OauthTokenSessionAttributeRequestProxy extends SessionAttributeRequestProxy implements Serviceable, Initializable
{
    private OauthProviderExtensionPoint _oauthEP;

    public void service(ServiceManager manager) throws ServiceException
    {
        _oauthEP = (OauthProviderExtensionPoint) manager.lookup(OauthProviderExtensionPoint.ROLE);
    }
    
    public void initialize() throws Exception
    {
        Set<String> providerIds = _oauthEP.getExtensionsIds();
        for (String providerId : providerIds)
        {
            OAuthProvider provider = _oauthEP.getExtension(providerId);
            _attributes.add(DefaultOauthProvider.OAUTH_ACCESS_TOKEN_SESSION_ATTRIBUTE + "$" + providerId);
            _attributes.add(DefaultOauthProvider.OAUTH_ACCESS_TOKEN_EXPIRATION_DATE_SESSION_ATTRIBUTE + "$" + providerId);
            _attributes.add(DefaultOauthProvider.OAUTH_REFRESH_TOKEN_SESSION_ATTRIBUTE + "$" + providerId);
            
            for (String customParam : provider.getCustomParametersName())
            {
                _attributes.add(DefaultOauthProvider.OAUTH_CUSTOM_PARAMETER + "$" + providerId + "#" + customParam);
            }
        }
    }
}
