/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.extrausermgt.authentication.oidc;

import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.openid.connect.sdk.OIDCScopeValue;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.ametys.plugins.extrausermgt.authentication.oidc.AbstractOIDCCredentialProvider;
import org.ametys.runtime.authentication.AccessDeniedException;
import org.apache.commons.io.IOUtils;

public class AutoDiscoveringOIDCCredentialProvider
extends AbstractOIDCCredentialProvider {
    private OIDCProviderMetadata _getProviderMetadata(URI issuerURI) throws Exception {
        URL providerConfigurationURL = issuerURI.resolve(".well-known/openid-configuration").toURL();
        try (InputStream stream = providerConfigurationURL.openStream();){
            String providerInfo = IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
            OIDCProviderMetadata oIDCProviderMetadata = OIDCProviderMetadata.parse((String)providerInfo);
            return oIDCProviderMetadata;
        }
    }

    @Override
    protected void initUrisScope() throws AccessDeniedException {
        Map paramValues = this.getParameterValues();
        try {
            URI issuerURI = URI.create((String)paramValues.get("authentication.oidc.issuerURI"));
            OIDCProviderMetadata providerMetadata = this._getProviderMetadata(issuerURI);
            this._authUri = providerMetadata.getAuthorizationEndpointURI();
            this._tokenEndpointUri = providerMetadata.getTokenEndpointURI();
            this._iss = providerMetadata.getIssuer();
            this._jwkSetURL = providerMetadata.getJWKSetURI().toURL();
            this._userInfoEndpoint = providerMetadata.getUserInfoEndpointURI();
            this._scope = Scope.parse((String)((String)paramValues.get("authentication.oidc.scopes")));
            this._scope.add((Object)OIDCScopeValue.OPENID);
        }
        catch (Exception e) {
            this.getLogger().error("Encountered a problem while retrieving provider metadata", (Throwable)e);
            throw new AccessDeniedException("Encountered a problem while retrieving provider metadata");
        }
    }
}

