/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.extrausermgt.groups.entraid;

import com.azure.core.credential.TokenCredential;
import com.azure.identity.ClientSecretCredential;
import com.azure.identity.ClientSecretCredentialBuilder;
import com.microsoft.graph.core.requests.IBaseClient;
import com.microsoft.graph.core.tasks.PageIterator;
import com.microsoft.graph.models.Group;
import com.microsoft.graph.models.GroupCollectionResponse;
import com.microsoft.graph.models.User;
import com.microsoft.graph.models.UserCollectionResponse;
import com.microsoft.graph.serviceclient.GraphServiceClient;
import com.microsoft.kiota.serialization.Parsable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.ametys.core.cache.AbstractCacheManager;
import org.ametys.core.cache.Cache;
import org.ametys.core.group.GroupIdentity;
import org.ametys.core.group.directory.GroupDirectory;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.core.user.directory.UserDirectory;
import org.ametys.core.user.population.UserPopulationDAO;
import org.ametys.core.util.SizeUtils;
import org.ametys.core.util.StringUtils;
import org.ametys.plugins.extrausermgt.users.entraid.EntraIDUserDirectory;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.slf4j.Logger;

public class EntraIDGroupDirectory
extends AbstractLogEnabled
implements GroupDirectory,
Serviceable,
Disposable {
    private static final String __PARAM_ASSOCIATED_USERDIRECTORY_ID = "org.ametys.plugins.extrausermgt.groups.entraid.userdirectory";
    private static final String __PARAM_APP_ID = "org.ametys.plugins.extrausermgt.groups.entraid.appid";
    private static final String __PARAM_CLIENT_SECRET = "org.ametys.plugins.extrausermgt.groups.entraid.clientsecret";
    private static final String __PARAM_TENANT_ID = "org.ametys.plugins.extrausermgt.groups.entraid.tenant";
    private static final String __PARAM_FILTER = "org.ametys.plugins.extrausermgt.groups.entraid.filter";
    private static final String[] __GROUP_ATTRIBUTES_SELECT = new String[]{"id", "displayName"};
    private static final String __ENTRAID_GROUPDIRECTORY_GROUP_BY_ID_CACHE_NAME_PREFIX = EntraIDGroupDirectory.class.getName() + "$group.by.id$";
    private static final String __ENTRAID_GROUPDIRECTORY_GROUPS_BY_USER_CACHE_NAME_PREFIX = EntraIDGroupDirectory.class.getName() + "$groups.by.user$";
    private static final String __ENTRAID_GROUPDIRECTORY_USERS_BY_GROUP_CACHE_NAME_PREFIX = EntraIDGroupDirectory.class.getName() + "$users.by.group$";
    private static final String __ENTRAID_GROUPDIRECTORY_ALL_GROUPS_CACHE_NAME_PREFIX = EntraIDGroupDirectory.class.getName() + "$all.groups$";
    private String _id;
    private I18nizableText _label;
    private String _groupDirectoryModelId;
    private Map<String, Object> _paramValues;
    private GraphServiceClient _graphClient;
    private String _filter;
    private String _associatedUserDirectoryId;
    private String _associatedPopulationId;
    private final String _uniqueCacheSuffix = StringUtils.generateKey();
    private AbstractCacheManager _cacheManager;
    private UserPopulationDAO _userPopulationDAO;
    private UserManager _userManager;

    public void service(ServiceManager serviceManager) throws ServiceException {
        this._userManager = (UserManager)serviceManager.lookup(UserManager.ROLE);
        this._cacheManager = (AbstractCacheManager)serviceManager.lookup(AbstractCacheManager.ROLE);
        this._userPopulationDAO = (UserPopulationDAO)serviceManager.lookup(UserPopulationDAO.ROLE);
    }

    public String getId() {
        return this._id;
    }

    public I18nizableText getLabel() {
        return this._label;
    }

    public void setId(String id) {
        this._id = id;
    }

    public void setLabel(I18nizableText label) {
        this._label = label;
    }

    public String getGroupDirectoryModelId() {
        return this._groupDirectoryModelId;
    }

    public Map<String, Object> getParameterValues() {
        return this._paramValues;
    }

    private void _createCaches() {
        this._cacheManager.createMemoryCache(__ENTRAID_GROUPDIRECTORY_GROUP_BY_ID_CACHE_NAME_PREFIX + this.getUniqueCacheIdSuffix(), this._buildI18n("PLUGINS_EXTRAUSERMGT_GROUPS_ENTRA_CACHE_GROUP_BY_ID_LABEL"), this._buildI18n("PLUGINS_EXTRAUSERMGT_GROUPS_ENTRA_CACHE_GROUP_BY_ID_DESC"), true, null);
        this._cacheManager.createMemoryCache(__ENTRAID_GROUPDIRECTORY_GROUPS_BY_USER_CACHE_NAME_PREFIX + this.getUniqueCacheIdSuffix(), this._buildI18n("PLUGINS_EXTRAUSERMGT_GROUPS_ENTRA_CACHE_GROUPS_BY_USER_LABEL"), this._buildI18n("PLUGINS_EXTRAUSERMGT_GROUPS_ENTRA_CACHE_GROUPS_BY_USER_DESC"), true, null);
        this._cacheManager.createMemoryCache(__ENTRAID_GROUPDIRECTORY_USERS_BY_GROUP_CACHE_NAME_PREFIX + this.getUniqueCacheIdSuffix(), this._buildI18n("PLUGINS_EXTRAUSERMGT_GROUPS_ENTRA_CACHE_USERS_BY_GROUP_LABEL"), this._buildI18n("PLUGINS_EXTRAUSERMGT_GROUPS_ENTRA_CACHE_USERS_BY_GROUP_DESC"), true, null);
        this._cacheManager.createMemoryCache(__ENTRAID_GROUPDIRECTORY_ALL_GROUPS_CACHE_NAME_PREFIX + this.getUniqueCacheIdSuffix(), this._buildI18n("PLUGINS_EXTRAUSERMGT_GROUPS_ENTRA_CACHE_ALL_GROUPS_LABEL"), this._buildI18n("PLUGINS_EXTRAUSERMGT_GROUPS_ENTRA_CACHE_ALL_GROUPS_DESC"), true, null);
    }

    private I18nizableText _buildI18n(String i18nKey) {
        String catalogue = "plugin.extra-user-management";
        I18nizableText groupDirectoryId = new I18nizableText(this.getId());
        Map<String, I18nizableText> labelParams = Map.of("id", groupDirectoryId);
        return new I18nizableText(catalogue, i18nKey, labelParams);
    }

    private Cache<String, org.ametys.core.group.Group> _getCacheGroupById() {
        return this._cacheManager.get(__ENTRAID_GROUPDIRECTORY_GROUP_BY_ID_CACHE_NAME_PREFIX + this.getUniqueCacheIdSuffix());
    }

    private Cache<UserIdentity, Set<String>> _getCacheGroupsByUser() {
        return this._cacheManager.get(__ENTRAID_GROUPDIRECTORY_GROUPS_BY_USER_CACHE_NAME_PREFIX + this.getUniqueCacheIdSuffix());
    }

    private Cache<GroupIdentity, Set<UserIdentity>> _getCacheUsersByGroup() {
        return this._cacheManager.get(__ENTRAID_GROUPDIRECTORY_USERS_BY_GROUP_CACHE_NAME_PREFIX + this.getUniqueCacheIdSuffix());
    }

    private Cache<String, Set<String>> _getCacheAllGroups() {
        return this._cacheManager.get(__ENTRAID_GROUPDIRECTORY_ALL_GROUPS_CACHE_NAME_PREFIX + this.getUniqueCacheIdSuffix());
    }

    private String getUniqueCacheIdSuffix() {
        return this._uniqueCacheSuffix;
    }

    public void init(String groupDirectoryModelId, Map<String, Object> paramValues) throws Exception {
        this._groupDirectoryModelId = groupDirectoryModelId;
        this._paramValues = paramValues;
        String populationAndUserDirectory = (String)paramValues.get(__PARAM_ASSOCIATED_USERDIRECTORY_ID);
        String[] split = populationAndUserDirectory.split("#");
        this._associatedPopulationId = split[0];
        this._associatedUserDirectoryId = split[1];
        String clientID = (String)paramValues.get(__PARAM_APP_ID);
        String clientSecret = (String)paramValues.get(__PARAM_CLIENT_SECRET);
        String tenant = (String)paramValues.get(__PARAM_TENANT_ID);
        this._filter = (String)paramValues.get(__PARAM_FILTER);
        ClientSecretCredential clientSecretCredential = ((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().clientId(clientID)).clientSecret(clientSecret).tenantId(tenant)).build();
        this._graphClient = new GraphServiceClient((TokenCredential)clientSecretCredential, new String[0]);
        this._createCaches();
    }

    public org.ametys.core.group.Group getGroup(String groupID) {
        return (org.ametys.core.group.Group)this._getCacheGroupById().get((Object)groupID, id -> {
            try {
                Group graphGroup = this._graphClient.groups().byGroupId(groupID).get();
                return new EntraIDGroup(graphGroup.getId(), graphGroup.getDisplayName(), this, this.getLogger());
            }
            catch (Exception e) {
                this.getLogger().warn("Unable to retrieve group '{}' from Entra ID", (Object)groupID, (Object)e);
                return null;
            }
        });
    }

    public Set<String> getUserGroups(UserIdentity userIdentity) {
        return (Set)this._getCacheGroupsByUser().get((Object)userIdentity, userId -> {
            String populationId = userIdentity.getPopulationId();
            UserDirectory userDirectory = this._userManager.getUserDirectory(populationId, userIdentity.getLogin());
            if (userDirectory == null || !populationId.equals(this._associatedPopulationId) || !this._associatedUserDirectoryId.equals(userDirectory.getId())) {
                return Set.of();
            }
            if (!(userDirectory instanceof EntraIDUserDirectory)) {
                this.getLogger().warn("The Entra ID group directory '{}' must be associated with a Entra ID user directory.", (Object)this.getId());
                return Set.of();
            }
            EntraIDUserDirectory entraUserDirectory = (EntraIDUserDirectory)userDirectory;
            HashSet groups = new HashSet();
            try {
                String userIdentifier = userIdentity.getLogin();
                Map paramValues = entraUserDirectory.getParameterValues();
                String loginAttribute = (String)paramValues.get("org.ametys.plugins.extrausermgt.users.entraid.loginattribute");
                String userPrincipalNameForQuery = userIdentifier;
                if ("onPremisesSamAccountName".equals(loginAttribute)) {
                    try {
                        List users = this._graphClient.users().get(requestConfiguration -> {
                            requestConfiguration.headers.add("ConsistencyLevel", "eventual");
                            requestConfiguration.queryParameters.count = true;
                            requestConfiguration.queryParameters.filter = "onPremisesSamAccountName eq '" + userIdentifier + "'";
                            requestConfiguration.queryParameters.select = new String[]{"userPrincipalName", "onPremisesSamAccountName"};
                        }).getValue();
                        if (!users.isEmpty()) {
                            userPrincipalNameForQuery = ((User)users.get(0)).getUserPrincipalName();
                        } else {
                            this.getLogger().debug("Unable to find user by SAM account name '{}', trying with UPN", (Object)userIdentifier);
                            userPrincipalNameForQuery = userIdentifier;
                        }
                    }
                    catch (Exception e) {
                        this.getLogger().warn("Unable to find user by SAM account name '{}', trying with UPN", (Object)userIdentifier, (Object)e);
                        userPrincipalNameForQuery = userIdentifier;
                    }
                }
                GroupCollectionResponse memberOfResponse = this._graphClient.users().byUserId(userPrincipalNameForQuery).memberOf().graphGroup().get(requestConfiguration -> {
                    requestConfiguration.queryParameters.select = new String[]{"id"};
                    Object filter = "groupTypes/any(c:c eq 'Unified')";
                    if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)this._filter)) {
                        filter = (String)filter + " and " + this._filter;
                    }
                    requestConfiguration.queryParameters.filter = filter;
                });
                new PageIterator.Builder().client((IBaseClient)this._graphClient).collectionPage((Parsable)memberOfResponse).collectionPageFactory(GroupCollectionResponse::createFromDiscriminatorValue).processPageItemCallback(group -> {
                    groups.add(group.getId());
                    return true;
                }).build().iterate();
            }
            catch (Exception e) {
                this.getLogger().error("Error while fetching groups for user " + userIdentity.getLogin(), (Throwable)e);
                return Set.of();
            }
            return groups;
        });
    }

    public Set<org.ametys.core.group.Group> getGroups() {
        String cacheKey = "ALL_GROUPS";
        Set groupIds = (Set)this._getCacheAllGroups().get((Object)cacheKey, key -> {
            HashSet<org.ametys.core.group.Group> groups = new HashSet<org.ametys.core.group.Group>(this.getGroups(-1, 0, Collections.emptyMap()));
            return groups.stream().map(org.ametys.core.group.Group::getIdentity).map(GroupIdentity::getId).collect(Collectors.toSet());
        });
        return groupIds.stream().map(this::getGroup).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public List<org.ametys.core.group.Group> getGroups(int count, int offset, Map parameters) {
        GroupCollectionResponse groupCollectionResponse = this._graphClient.groups().get(requestConfiguration -> {
            String pattern;
            requestConfiguration.headers.add("ConsistencyLevel", "eventual");
            String string = pattern = parameters != null ? (String)parameters.get("pattern") : null;
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)pattern)) {
                requestConfiguration.queryParameters.search = "\"displayName:" + pattern + "\"";
            }
            if (count > 0 && count < Integer.MAX_VALUE) {
                requestConfiguration.queryParameters.top = Math.min(count + offset, 999);
            }
            Object filter = "groupTypes/any(c:c eq 'Unified')";
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)this._filter)) {
                filter = (String)filter + " and " + this._filter;
            }
            requestConfiguration.queryParameters.filter = filter;
            requestConfiguration.queryParameters.select = __GROUP_ATTRIBUTES_SELECT;
        });
        ArrayList<org.ametys.core.group.Group> result = new ArrayList<org.ametys.core.group.Group>();
        AtomicInteger offsetCounter = new AtomicInteger(offset);
        try {
            new PageIterator.Builder().client((IBaseClient)this._graphClient).collectionPage((Parsable)groupCollectionResponse).collectionPageFactory(GroupCollectionResponse::createFromDiscriminatorValue).processPageItemCallback(group -> {
                if (offsetCounter.decrementAndGet() <= 0) {
                    this._handleGroup((Group)group, (List<org.ametys.core.group.Group>)result);
                }
                return count <= 0 || result.size() < count;
            }).build().iterate();
        }
        catch (Exception e) {
            this.getLogger().error("Error while fetching groups from Entra ID", (Throwable)e);
            return List.of();
        }
        return result;
    }

    private void _handleGroup(Group group, List<org.ametys.core.group.Group> groups) {
        EntraIDGroup storedGroup = new EntraIDGroup(group.getId(), group.getDisplayName(), this, this.getLogger());
        groups.add(storedGroup);
        this._getCacheGroupById().put((Object)group.getId(), (Object)storedGroup);
    }

    public void dispose() {
        this._cacheManager.removeCache(__ENTRAID_GROUPDIRECTORY_GROUP_BY_ID_CACHE_NAME_PREFIX + this.getUniqueCacheIdSuffix(), AbstractCacheManager.CacheType.MEMORY);
        this._cacheManager.removeCache(__ENTRAID_GROUPDIRECTORY_GROUPS_BY_USER_CACHE_NAME_PREFIX + this.getUniqueCacheIdSuffix(), AbstractCacheManager.CacheType.MEMORY);
        this._cacheManager.removeCache(__ENTRAID_GROUPDIRECTORY_USERS_BY_GROUP_CACHE_NAME_PREFIX + this.getUniqueCacheIdSuffix(), AbstractCacheManager.CacheType.MEMORY);
        this._cacheManager.removeCache(__ENTRAID_GROUPDIRECTORY_ALL_GROUPS_CACHE_NAME_PREFIX + this.getUniqueCacheIdSuffix(), AbstractCacheManager.CacheType.MEMORY);
    }

    private static class EntraIDGroup
    implements org.ametys.core.group.Group {
        private String _id;
        private String _label;
        @SizeUtils.ExcludeFromSizeCalculation
        private Logger _logger;
        @SizeUtils.ExcludeFromSizeCalculation
        private EntraIDGroupDirectory _directory;

        public EntraIDGroup(String id, String label, EntraIDGroupDirectory directory, Logger logger) {
            this._id = id;
            this._label = label;
            this._directory = directory;
            this._logger = logger;
        }

        public String getLabel() {
            return this._label;
        }

        public GroupIdentity getIdentity() {
            return new GroupIdentity(this._id, this._directory.getId());
        }

        public GroupDirectory getGroupDirectory() {
            return this._directory;
        }

        public Set<UserIdentity> getUsers() {
            GroupIdentity groupIdentity = this.getIdentity();
            return (Set)this._directory._getCacheUsersByGroup().get((Object)groupIdentity, key -> {
                HashSet users = new HashSet();
                try {
                    UserCollectionResponse membersResponse = this._directory._graphClient.groups().byGroupId(this._id).members().graphUser().get(requestConfiguration -> {
                        requestConfiguration.queryParameters.select = new String[]{"userPrincipalName", "onPremisesSamAccountName"};
                    });
                    UserDirectory associatedUserDirectory = this._directory._userPopulationDAO.getUserPopulation(this._directory._associatedPopulationId).getUserDirectory(this._directory._associatedUserDirectoryId);
                    if (!(associatedUserDirectory instanceof EntraIDUserDirectory)) {
                        this._logger.warn("An Entra ID group directory must be associated with an Entra ID user directory.");
                        return Set.of();
                    }
                    EntraIDUserDirectory entraUserDirectory = (EntraIDUserDirectory)associatedUserDirectory;
                    new PageIterator.Builder().client((IBaseClient)this._directory._graphClient).collectionPage((Parsable)membersResponse).collectionPageFactory(UserCollectionResponse::createFromDiscriminatorValue).processPageItemCallback(user -> {
                        users.add(new UserIdentity(entraUserDirectory.getUserIdentifier((User)user), this._directory._associatedPopulationId));
                        return true;
                    }).build().iterate();
                }
                catch (Exception e) {
                    this._logger.error("Error while fetching members for Entra ID group " + this._id, (Throwable)e);
                }
                return users;
            });
        }

        public boolean equals(Object another) {
            if (another == null || !(another instanceof EntraIDGroup)) {
                return false;
            }
            EntraIDGroup otherGroup = (EntraIDGroup)another;
            return this._id != null && this._id.equals(otherGroup._id);
        }

        public int hashCode() {
            return this._id.hashCode();
        }
    }
}

