/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.extrausermgt.authentication.cas;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.ServletContext;
import org.ametys.core.authentication.AbstractCredentialProvider;
import org.ametys.core.authentication.BlockingCredentialProvider;
import org.ametys.core.authentication.NonBlockingCredentialProvider;
import org.ametys.core.servletwrapper.filter.ServletFilterWrapper;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.util.URIUtils;
import org.ametys.plugins.extrausermgt.authentication.cas.AmetysCas20ProxyReceivingTicketValidationFilter;
import org.ametys.plugins.extrausermgt.authentication.cas.AmetysCas20ProxyTicketValidator;
import org.ametys.plugins.extrausermgt.authentication.cas.CasProxyGrantingTicketManager;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Session;
import org.apache.commons.lang3.StringUtils;
import org.jasig.cas.client.authentication.AuthenticationFilter;
import org.jasig.cas.client.util.HttpServletRequestWrapperFilter;
import org.jasig.cas.client.validation.Assertion;

public class CASCredentialProvider
extends AbstractCredentialProvider
implements NonBlockingCredentialProvider,
BlockingCredentialProvider,
Contextualizable {
    public static final String PARAM_SERVER_URL = "authentication.cas.serverUrl";
    private static final String __PARAM_REQUEST_PROXY_TICKETS = "authentication.cas.requestProxyTickets";
    private static final String __PARAM_ACCEPT_ANY_PROXY = "authentication.cas.acceptAnyProxy";
    private static final String __PARAM_AUTHORIZED_PROXY_CHAINS = "authentication.cas.authorizedProxyChain";
    private static final String __PARAM_GATEWAY_ENABLED = "authentication.cas.enableGateway";
    protected String _serverUrl;
    private Context _context;
    private boolean _requestProxyTickets;
    private boolean _acceptAnyProxy;
    private String _authorizedProxyChains;
    private boolean _gatewayModeEnabled;

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public void init(String id, String cpModelId, Map<String, Object> paramValues, String label) throws Exception {
        super.init(id, cpModelId, paramValues, label);
        this._serverUrl = (String)paramValues.get(PARAM_SERVER_URL);
        this._requestProxyTickets = (Boolean)paramValues.get(__PARAM_REQUEST_PROXY_TICKETS);
        this._acceptAnyProxy = (Boolean)paramValues.get(__PARAM_ACCEPT_ANY_PROXY);
        this._authorizedProxyChains = (String)paramValues.get(__PARAM_AUTHORIZED_PROXY_CHAINS);
        this._gatewayModeEnabled = (Boolean)paramValues.get(__PARAM_GATEWAY_ENABLED);
    }

    public boolean blockingIsStillConnected(UserIdentity userIdentity, Redirector redirector) throws Exception {
        return StringUtils.equals((CharSequence)userIdentity.getLogin(), (CharSequence)this._getLoginFromFilter(false, redirector));
    }

    public boolean nonBlockingIsStillConnected(UserIdentity userIdentity, Redirector redirector) throws Exception {
        return this.blockingIsStillConnected(userIdentity, redirector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String _getLoginFromFilter(boolean gateway, Redirector redirector) throws Exception {
        Map objectModel = ContextHelper.getObjectModel((Context)this._context);
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        if (request.getRequestURI().startsWith(request.getContextPath() + "/plugins/core/authenticate/") && "true".equals(request.getParameter("proxy"))) {
            String redirectUrl = "cocoon://_plugins/extra-user-management/ametysCasProxy";
            this.getLogger().debug("Redirecting to '{}'", (Object)redirector);
            redirector.redirect(true, redirectUrl);
            return null;
        }
        StringBuffer serverName = new StringBuffer(request.getServerName());
        if (request.isSecure()) {
            if (request.getServerPort() != 443) {
                serverName.append(":");
                serverName.append(request.getServerPort());
            }
        } else if (request.getServerPort() != 80) {
            serverName.append(":");
            serverName.append(request.getServerPort());
        }
        String name = serverName.toString();
        ArrayList<ServletFilterWrapper> runtimeFilters = new ArrayList<ServletFilterWrapper>();
        ServletContext servletContext = (ServletContext)objectModel.get("httpservletcontext");
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        try {
            parameters.put("casServerLoginUrl", this._serverUrl + "/login");
            parameters.put("serverName", name);
            parameters.put("gateway", String.valueOf(gateway));
            ServletFilterWrapper runtimeFilter = new ServletFilterWrapper((Filter)new AuthenticationFilter());
            runtimeFilter.init(parameters, servletContext);
            runtimeFilters.add(runtimeFilter);
            parameters.clear();
            parameters.put("casServerUrlPrefix", this._serverUrl);
            parameters.put("serverName", name);
            if (this._acceptAnyProxy) {
                parameters.put("acceptAnyProxy", "true");
            } else {
                parameters.put("allowedProxyChains", this._authorizedProxyChains);
            }
            if (this._requestProxyTickets && StringUtils.isNotEmpty((CharSequence)request.getParameter("ticket"))) {
                String proxyCallbackUrl = "https://" + name + this._getProxyCallbackRelativeUrl(request);
                this.getLogger().debug("The computed proxy callback url is: {}", (Object)proxyCallbackUrl);
                parameters.put("proxyCallbackUrl", proxyCallbackUrl);
                parameters.put("proxyGrantingTicketStorageClass", CasProxyGrantingTicketManager.class.getName());
                parameters.put("ticketValidatorClass", AmetysCas20ProxyTicketValidator.class.getName());
            }
            runtimeFilter = new ServletFilterWrapper((Filter)new AmetysCas20ProxyReceivingTicketValidationFilter());
            runtimeFilter.init(parameters, servletContext);
            runtimeFilters.add(runtimeFilter);
            parameters.clear();
            runtimeFilter = new ServletFilterWrapper((Filter)new HttpServletRequestWrapperFilter());
            runtimeFilter.init(parameters, servletContext);
            runtimeFilters.add(runtimeFilter);
            this.getLogger().debug("Executing CAS filter chain...");
            for (ServletFilterWrapper filter : runtimeFilters) {
                filter.doFilter(objectModel, redirector);
            }
        }
        finally {
            this.getLogger().debug("Destroying CAS filter chain...");
            for (ServletFilterWrapper filter : runtimeFilters) {
                filter.destroy();
            }
        }
        if (!redirector.hasRedirected()) {
            return this._getLogin(request);
        }
        return null;
    }

    private String _getProxyCallbackRelativeUrl(Request request) {
        List contexts;
        Integer cpIndex;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("proxy", "true");
        String userPopulationId = (String)request.getAttribute("Runtime:CurrentUserPopulationId");
        if (StringUtils.isNotEmpty((CharSequence)userPopulationId)) {
            params.put("UserPopulation", userPopulationId);
        }
        if ((cpIndex = this._getRunningCpIndex(request)).equals(-1)) {
            cpIndex = 0;
        }
        String contextAsString = (contexts = (List)request.getAttribute("Runtime:Contexts")) != null ? StringUtils.join((Object[])contexts.toArray(), (char)',') : "";
        params.put("contexts", contextAsString);
        return URIUtils.buildURI((String)(request.getContextPath() + "/plugins/core/authenticate/" + cpIndex.toString()), params);
    }

    private Integer _getRunningCpIndex(Request request) {
        Integer formerRunningCredentialProviderIndex;
        Integer cpIndex = (Integer)request.getAttribute("Runtime:RequestCredentialProviderIndex");
        if (cpIndex != null) {
            return cpIndex;
        }
        Session session = request.getSession(false);
        if (session != null && (formerRunningCredentialProviderIndex = (Integer)session.getAttribute("Runtime:ConnectingCredentialProviderIndexLastKnown")) != null) {
            return formerRunningCredentialProviderIndex;
        }
        return -1;
    }

    public boolean blockingGrantAnonymousRequest() {
        return false;
    }

    public boolean nonBlockingGrantAnonymousRequest() {
        return false;
    }

    public UserIdentity blockingGetUserIdentity(Redirector redirector) throws Exception {
        String userLogin = this._getLoginFromFilter(false, redirector);
        if (redirector.hasRedirected()) {
            return null;
        }
        if (userLogin == null) {
            throw new IllegalStateException("CAS authentication needs a CAS filter.");
        }
        return new UserIdentity(userLogin, null);
    }

    public UserIdentity nonBlockingGetUserIdentity(Redirector redirector) throws Exception {
        if (!this._gatewayModeEnabled) {
            return null;
        }
        String userLogin = this._getLoginFromFilter(true, redirector);
        if (userLogin == null) {
            return null;
        }
        return new UserIdentity(userLogin, null);
    }

    public void blockingUserNotAllowed(Redirector redirector) throws Exception {
    }

    public void nonBlockingUserNotAllowed(Redirector redirector) throws Exception {
    }

    public void blockingUserAllowed(UserIdentity userIdentity, Redirector redirector) {
    }

    public void nonBlockingUserAllowed(UserIdentity userIdentity, Redirector redirector) {
    }

    public boolean requiresNewWindow() {
        return true;
    }

    protected String _getLogin(Request request) {
        String userLogin = null;
        Session session = request.getSession(false);
        Assertion assertion = (Assertion)(session == null ? request.getAttribute("_const_cas_assertion_") : session.getAttribute("_const_cas_assertion_"));
        if (assertion != null) {
            userLogin = assertion.getPrincipal().getName();
        }
        return userLogin;
    }
}

