/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.extrausermgt.authentication.msal;

import com.microsoft.aad.msal4j.AuthorizationCodeParameters;
import com.microsoft.aad.msal4j.AuthorizationRequestUrlParameters;
import com.microsoft.aad.msal4j.ClientCredentialFactory;
import com.microsoft.aad.msal4j.ConfidentialClientApplication;
import com.microsoft.aad.msal4j.IAccount;
import com.microsoft.aad.msal4j.IAuthenticationResult;
import com.microsoft.aad.msal4j.IClientCredential;
import com.microsoft.aad.msal4j.IClientSecret;
import com.microsoft.aad.msal4j.Prompt;
import com.microsoft.aad.msal4j.ResponseMode;
import com.microsoft.aad.msal4j.SilentParameters;
import com.nimbusds.jwt.SignedJWT;
import java.io.IOException;
import java.net.URI;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.ametys.core.authentication.AbstractCredentialProvider;
import org.ametys.core.authentication.BlockingCredentialProvider;
import org.ametys.core.authentication.NonBlockingCredentialProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.extrausermgt.authentication.oidc.OIDCBasedCredentialProvider;
import org.ametys.runtime.authentication.AccessDeniedException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Session;

public abstract class AbstractMSALCredentialProvider
extends AbstractCredentialProvider
implements OIDCBasedCredentialProvider,
BlockingCredentialProvider,
NonBlockingCredentialProvider,
Contextualizable {
    public static final String ACCESS_TOKEN_SESSION_ATTRIBUTE = "msal_token";
    private static final String __ATTRIBUTE_EXPIRATIONDATE = "msal_expirationDate";
    private static final String __ATTRIBUTE_ACCOUNT = "msal_account";
    private static final String __ATTRIBUTE_TOKENCACHE = "msal_tokenCache";
    private static final String __ATTRIBUTE_CODE = "msal_code";
    private static final String __ATTRIBUTE_SILENT = "msal_silent";
    private static final String __ATTRIBUTE_STATE = "msal_state";
    private static final String __ATTRIBUTE_NONCE = "msal_nonce";
    protected String _clientID;
    protected String _clientSecret;
    protected boolean _prompt;
    protected boolean _silent;
    private Context _context;

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    protected void init(String cliendId, String clientSecret, boolean prompt, boolean silent) {
        this._clientID = cliendId;
        this._clientSecret = clientSecret;
        this._prompt = prompt;
        this._silent = silent;
    }

    private ConfidentialClientApplication _getClient() throws Exception {
        IClientSecret secret = ClientCredentialFactory.createFromSecret((String)this._clientSecret);
        ConfidentialClientApplication client = ((ConfidentialClientApplication.Builder)ConfidentialClientApplication.builder((String)this._clientID, (IClientCredential)secret).authority(this.getAuthority())).build();
        return client;
    }

    protected abstract String getAuthority();

    @Override
    public String getClientId() {
        return this._clientID;
    }

    public boolean blockingIsStillConnected(UserIdentity userIdentity, Redirector redirector) throws Exception {
        Map objectModel = ContextHelper.getObjectModel((Context)this._context);
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        Session session = request.getSession(true);
        this.refreshTokenIfNeeded(session);
        return true;
    }

    public boolean nonBlockingIsStillConnected(UserIdentity userIdentity, Redirector redirector) throws Exception {
        return this.blockingIsStillConnected(userIdentity, redirector);
    }

    public boolean blockingGrantAnonymousRequest() {
        return false;
    }

    public boolean nonBlockingGrantAnonymousRequest() {
        return false;
    }

    private String _getRequestURI(Request request) {
        StringBuilder uriBuilder = new StringBuilder();
        if (request.isSecure()) {
            uriBuilder.append("https://").append(request.getServerName());
            if (request.getServerPort() != 443) {
                uriBuilder.append(":");
                uriBuilder.append(request.getServerPort());
            }
        } else {
            uriBuilder.append("http://").append(request.getServerName());
            if (request.getServerPort() != 80) {
                uriBuilder.append(":");
                uriBuilder.append(request.getServerPort());
            }
        }
        uriBuilder.append(request.getContextPath());
        uriBuilder.append("/_extra-user-management/oidc-callback");
        return uriBuilder.toString();
    }

    private UserIdentity _login(boolean silent, Redirector redirector) throws Exception {
        String state;
        String code;
        Map objectModel = ContextHelper.getObjectModel((Context)this._context);
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        Session session = request.getSession(true);
        ConfidentialClientApplication client = this._getClient();
        String requestURI = this._getRequestURI(request);
        this.getLogger().debug("MSAL CredentialProvider callback URI: {}", (Object)requestURI);
        String storedCode = (String)session.getAttribute(__ATTRIBUTE_CODE);
        if (storedCode != null) {
            return this._getUserIdentityFromCode(storedCode, session, client, requestURI);
        }
        boolean wasSilent = false;
        if (silent) {
            wasSilent = "true".equals(session.getAttribute(__ATTRIBUTE_SILENT));
        }
        if ((code = request.getParameter("code")) == null) {
            if (wasSilent) {
                return null;
            }
            if (silent) {
                session.setAttribute(__ATTRIBUTE_SILENT, (Object)"true");
            }
            String state2 = UUID.randomUUID().toString();
            session.setAttribute(__ATTRIBUTE_STATE, (Object)state2);
            Object actualRedirectUri = request.getRequestURI();
            if (request.getQueryString() != null) {
                actualRedirectUri = (String)actualRedirectUri + "?" + request.getQueryString();
            }
            session.setAttribute("oidc_actualRedirectUri", actualRedirectUri);
            String nonce = UUID.randomUUID().toString();
            session.setAttribute(__ATTRIBUTE_NONCE, (Object)nonce);
            AuthorizationRequestUrlParameters.Builder builder = AuthorizationRequestUrlParameters.builder((String)requestURI, this.getScopes()).responseMode(ResponseMode.QUERY).state(state2).nonce(nonce);
            if (silent) {
                builder.prompt(Prompt.NONE);
            } else if (this._prompt) {
                builder.prompt(Prompt.SELECT_ACCOUNT);
            }
            AuthorizationRequestUrlParameters parameters = builder.build();
            String authorizationRequestUrl = client.getAuthorizationRequestUrl(parameters).toString();
            redirector.redirect(false, authorizationRequestUrl);
            return null;
        }
        String storedState = (String)session.getAttribute(__ATTRIBUTE_STATE);
        if (!storedState.equals(state = request.getParameter("state"))) {
            throw new AccessDeniedException("MSAL state mismatch");
        }
        session.setAttribute(__ATTRIBUTE_STATE, null);
        session.setAttribute(__ATTRIBUTE_CODE, (Object)code);
        String redirectUri = (String)session.getAttribute("oidc_actualRedirectUri");
        redirector.redirect(true, redirectUri);
        return null;
    }

    protected Set<String> getScopes() {
        return Set.of("openid");
    }

    private UserIdentity _getUserIdentityFromCode(String code, Session session, ConfidentialClientApplication client, String requestURI) throws Exception {
        String nonce;
        AuthorizationCodeParameters authParams = AuthorizationCodeParameters.builder((String)code, (URI)new URI(requestURI)).scopes(this.getScopes()).build();
        IAuthenticationResult result = (IAuthenticationResult)client.acquireToken(authParams).get();
        Map tokenClaims = SignedJWT.parse((String)result.idToken()).getJWTClaimsSet().getClaims();
        String storedNonce = (String)session.getAttribute(__ATTRIBUTE_NONCE);
        if (!storedNonce.equals(nonce = (String)tokenClaims.get("nonce"))) {
            throw new AccessDeniedException("MSAL nonce mismatch");
        }
        session.setAttribute(__ATTRIBUTE_NONCE, null);
        session.setAttribute(__ATTRIBUTE_EXPIRATIONDATE, (Object)result.expiresOnDate());
        session.setAttribute(__ATTRIBUTE_TOKENCACHE, (Object)client.tokenCache().serialize());
        session.setAttribute(__ATTRIBUTE_ACCOUNT, (Object)result.account());
        session.setAttribute(ACCESS_TOKEN_SESSION_ATTRIBUTE, (Object)result.accessToken());
        String login = this.getLogin(result);
        return new UserIdentity(login, null);
    }

    protected String getLogin(IAuthenticationResult result) {
        return result.account().username();
    }

    public UserIdentity blockingGetUserIdentity(Redirector redirector) throws Exception {
        return this._login(false, redirector);
    }

    public UserIdentity nonBlockingGetUserIdentity(Redirector redirector) throws Exception {
        if (!this._silent) {
            return null;
        }
        return this._login(true, redirector);
    }

    public void blockingUserNotAllowed(Redirector redirector) {
    }

    public void nonBlockingUserNotAllowed(Redirector redirector) throws Exception {
    }

    public void blockingUserAllowed(UserIdentity userIdentity, Redirector redirector) throws ProcessingException, IOException {
    }

    public void nonBlockingUserAllowed(UserIdentity userIdentity, Redirector redirector) {
    }

    public boolean requiresNewWindow() {
        return true;
    }

    public void refreshTokenIfNeeded(Session session) throws Exception {
        Date expDat = (Date)session.getAttribute(__ATTRIBUTE_EXPIRATIONDATE);
        if (expDat != null && new Date().after(expDat)) {
            ConfidentialClientApplication client = this._getClient();
            IAccount account = (IAccount)session.getAttribute(__ATTRIBUTE_ACCOUNT);
            String tokenCache = (String)session.getAttribute(__ATTRIBUTE_TOKENCACHE);
            SilentParameters parameters = SilentParameters.builder(Set.of("openid"), (IAccount)account).build();
            client.tokenCache().deserialize(tokenCache);
            IAuthenticationResult result = (IAuthenticationResult)client.acquireTokenSilently(parameters).get();
            session.setAttribute(__ATTRIBUTE_EXPIRATIONDATE, (Object)result.expiresOnDate());
            session.setAttribute(__ATTRIBUTE_TOKENCACHE, (Object)client.tokenCache().serialize());
            session.setAttribute(__ATTRIBUTE_ACCOUNT, (Object)result.account());
            session.setAttribute(ACCESS_TOKEN_SESSION_ATTRIBUTE, (Object)result.accessToken());
        }
    }
}

