/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.workspaces.extrausermgt.authentication.oauth;

import com.nimbusds.oauth2.sdk.AuthorizationCodeGrant;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.AuthorizationResponse;
import com.nimbusds.oauth2.sdk.ErrorObject;
import com.nimbusds.oauth2.sdk.id.State;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.ametys.plugins.extrausermgt.oauth.OAuthProvider;
import org.ametys.plugins.extrausermgt.oauth.OauthProviderExtensionPoint;
import org.ametys.runtime.authentication.AccessDeniedException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.acting.AbstractAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Session;
import org.apache.cocoon.environment.SourceResolver;

public class OAuthCallbackAction
extends AbstractAction
implements ThreadSafe,
Serviceable {
    private OauthProviderExtensionPoint _oauthEP;

    public void service(ServiceManager manager) throws ServiceException {
        this._oauthEP = (OauthProviderExtensionPoint)((Object)manager.lookup(OauthProviderExtensionPoint.ROLE));
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        HashMap<String, List<String>> params = new HashMap<String, List<String>>();
        Iterator paramIterator = request.getParameterNames().asIterator();
        while (paramIterator.hasNext()) {
            String paramName = (String)paramIterator.next();
            params.put(paramName, Arrays.asList(request.getParameterValues(paramName)));
        }
        AuthorizationResponse response = AuthorizationResponse.parse((URI)URI.create(request.getRequestURI()), params);
        Session session = request.getSession();
        if (!response.indicatesSuccess()) {
            ErrorObject errorObject = response.toErrorResponse().getErrorObject();
            throw new AccessDeniedException("Oauth authorization request failed with http status '" + errorObject.getHTTPStatusCode() + "', code '" + errorObject.getCode() + "' and description '" + errorObject.getDescription() + "'.");
        }
        this.checkResponseIntegrity(response, session);
        OAuthProvider provider = this._oauthEP.getProviderForState(response.getState());
        AuthorizationCodeGrant grant = new AuthorizationCodeGrant(response.toSuccessResponse().getAuthorizationCode(), URI.create(request.getRequestURI()));
        provider.requestAccessToken((AuthorizationGrant)grant);
        String originalRequest = (String)session.getAttribute("oauth.redirect.uri");
        if (!redirector.hasRedirected()) {
            redirector.redirect(false, originalRequest);
        }
        return EMPTY_MAP;
    }

    protected void checkResponseIntegrity(AuthorizationResponse response, Session session) {
        State state = (State)session.getAttribute("oauth.state");
        if (state == null || !state.equals((Object)response.getState())) {
            throw new AccessDeniedException("Failed to retrieve the authorization code. Oauth state mismatch.");
        }
        session.removeAttribute("oauth.state");
    }
}

