/*
 *  Copyright 2024 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.extrausermgt.authentication.msal;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;

/**
 * Sign in through ADFS, using the OpenId Connect protocol.
 */
public class ADFSCredentialProvider extends AbstractMSALCredentialProvider
{
    private String _adfsServer;
    
    @Override
    public void init(String id, String cpModelId, Map<String, Object> paramValues, String label) throws Exception
    {
        super.init(id, cpModelId, paramValues, label);
        
        _adfsServer = (String) paramValues.get("authentication.adfs.url");

        String clientID = (String) paramValues.get("authentication.adfs.appid");
        String clientSecret = (String) paramValues.get("authentication.adfs.clientsecret");
        boolean silent = (boolean) paramValues.get("authentication.adfs.silent");

        init(clientID, clientSecret, false, silent);
    }
    
    @Override
    protected String getAuthority()
    {
        return _adfsServer;
    }
    
    public String getIssuer()
    {
        return getAuthority();
    }
    
    public URL getJwkSetURL()
    {
        try
        {
            return new URI(getAuthority() + "/discovery/keys").toURL();
        }
        catch (MalformedURLException | URISyntaxException e)
        {
            throw new IllegalArgumentException("Invalid JWKSetURL", e);
        }
    }
}
