/*
 *  Copyright 2021 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.extrausermgt.authentication.msal;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;

import org.ametys.runtime.plugin.ExtensionPoint;

/**
 * This extension point handle a list of scopes for OIDC.
 */
public class OIDCScopesExtensionPoint implements ExtensionPoint<String>, Component
{
    /** The avalon role */
    public static final String ROLE = OIDCScopesExtensionPoint.class.getName();
    
    private Set<String> _extensionIds = new HashSet<>();
    private Set<String> _scopes = new HashSet<>();
    
    public void addExtension(String id, String pluginName, String featureName, Configuration configuration) throws ConfigurationException
    {
        _extensionIds.add(id);
        for (Configuration scopeConfiguration : configuration.getChildren("scope"))
        {
            _scopes.add(scopeConfiguration.getValue());
        }
    }

    public void initializeExtensions() throws Exception
    {
        _scopes.add("openid");
    }

    public boolean hasExtension(String id)
    {
        return _extensionIds.contains(id);
    }

    public String getExtension(String id)
    {
        return hasExtension(id) ? id : null;
    }

    public Set<String> getExtensionsIds()
    {
        return Collections.unmodifiableSet(_extensionIds);
    }

    /**
     * Get all scopes
     * @return the scope set
     */
    public Set<String> getScopes()
    {
        return Collections.unmodifiableSet(_scopes);
    }
}
