/*
 *  Copyright 2022 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.extrausermgt.authentication.oidc;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;

import org.ametys.runtime.authentication.AccessDeniedException;

import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.id.Issuer;
import com.nimbusds.openid.connect.sdk.OIDCScopeValue;

/**
 * Sign in through a OIDC application, using the OpenId Connect protocol.
 */
public class GenericOIDCCredentialProvider extends AbstractOIDCCredentialProvider
{
    @Override
    protected void initUrisScope() throws AccessDeniedException
    {
        Map<String, Object> paramValues = getParameterValues();
        try
        {
            _authUri = URI.create((String) paramValues.get("authentication.oidc.authUri"));
            _tokenEndpointUri = URI.create((String) paramValues.get("authentication.oidc.tokenEndpointUri"));
            _iss = new Issuer((String) paramValues.get("authentication.oidc.issuer"));
            _jwkSetURL = new URI((String) paramValues.get("authentication.oidc.jwkSetURL")).toURL();
            _userInfoEndpoint = URI.create((String) paramValues.get("authentication.oidc.userInfoEndpoint"));
        }
        catch (MalformedURLException | URISyntaxException e)
        {
            getLogger().error("Encountered a problem when creating the jwkSetURL", e);
            throw new AccessDeniedException("Encountered a problem when creating the jwkSetURL");
        }
        
        _scope = Scope.parse((String) paramValues.get("authentication.oidc.scopes"));
        _scope.add(OIDCScopeValue.OPENID);
    }
}
