/*
 *  Copyright 2022 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.extrausermgt.authentication.oidc;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;

import org.ametys.runtime.authentication.AccessDeniedException;

import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.id.Issuer;

/**
 *  Sign in through Google, using the OpenId Connect protocol.
 */
public class GoogleCredentialProvider extends AbstractOIDCCredentialProvider
{
    private final Scope _scopeGg = new Scope("openid", "email", "profile");
    
    @Override
    protected void initUrisScope() throws AccessDeniedException
    {
        try
        {
            _authUri = URI.create("https://accounts.google.com/o/oauth2/v2/auth?prompt=consent");
            _tokenEndpointUri = URI.create("https://oauth2.googleapis.com/token");
            _iss = new Issuer("https://accounts.google.com");
            _jwkSetURL = new URI("https://www.googleapis.com/oauth2/v3/certs").toURL();
            _userInfoEndpoint = URI.create("https://www.googleapis.com/oauth2/v3/userinfo");
            _scope = _scopeGg;
        }
        catch (MalformedURLException | URISyntaxException e)
        {
            getLogger().error("Encountered a problem when creating the jwkSetURL", e);
            throw new AccessDeniedException("Encountered a problem when creating the jwkSetURL");
        }
    }
}
