/*
 *  Copyright 2022 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.extrausermgt.authentication.oidc.endofauthenticationprocess;

import org.apache.avalon.framework.component.Component;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;

import org.ametys.core.user.population.UserPopulation;
import org.ametys.runtime.authentication.AccessDeniedException;
import org.ametys.runtime.exception.ServiceUnavailableException;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;

/**
 * Entry point of the end of the authentication process
 */
public class EndOfAuthenticationProcess extends AbstractLogEnabled implements Component
{
    /** The Avalon role */
    public static final String ROLE = EndOfAuthenticationProcess.class.getName();

    /**
     * The user has been authenticated but we might need to sign him in
     * @param login The email address of the user
     * @param firstName The user's first name
     * @param lastName The user's last name
     * @param userPopulation The user population
     * @param redirector A redirector
     * @param request The requests
     * @throws AccessDeniedException If an error occurs 
     * @throws ServiceUnavailableException If the server is in maintenance mode
     */
    public void unexistingUser(String login, String firstName, String lastName, UserPopulation userPopulation, Redirector redirector, Request request) throws AccessDeniedException, ServiceUnavailableException
    {
        // Nothing to do
    }
}
