/*
 *  Copyright 2017 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.extraction.execution;

import org.apache.excalibur.source.TraversableSource;

import org.ametys.plugins.core.impl.enumerator.AbstractTraversableSourceEnumerator;
import org.ametys.plugins.extraction.ExtractionConstants;

/**
 * Enumerator for extraction definition files
 */
public class ExtractionDefinitionFilesEnumerator extends AbstractTraversableSourceEnumerator
{
    @Override
    protected String getLocation()
    {
        return ExtractionConstants.DEFINITIONS_DIR;
    }

    @Override
    protected boolean acceptSource(TraversableSource source)
    {
        return source.getName().endsWith(".xml");
    }
}
