/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.extraction.edition;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.ametys.cms.contenttype.ContentType;
import org.ametys.cms.contenttype.ContentTypeExtensionPoint;
import org.ametys.cms.search.GetQueryFromJSONHelper;
import org.ametys.cms.search.QueryBuilder;
import org.ametys.cms.search.model.SearchModel;
import org.ametys.cms.search.query.AndQuery;
import org.ametys.cms.search.query.ContentTypeOrMixinTypeQuery;
import org.ametys.cms.search.query.ContentTypeQuery;
import org.ametys.cms.search.query.MixinTypeQuery;
import org.ametys.cms.search.query.Query;
import org.ametys.cms.search.ui.model.SearchUIModelExtensionPoint;
import org.ametys.core.ui.Callable;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.core.util.I18nUtils;
import org.ametys.core.util.JSONUtils;
import org.ametys.core.util.language.UserLanguagesManager;
import org.ametys.plugins.queriesdirectory.Query;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.thesaurus.Thesaurus;
import org.ametys.plugins.thesaurus.ThesaurusDAO;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class EditExtractionNodeManager
extends AbstractLogEnabled
implements Component,
Serviceable {
    public static final String ROLE = EditExtractionNodeManager.class.getName();
    private ThesaurusDAO _thesaurusDAO;
    private AmetysObjectResolver _resolver;
    private JSONUtils _jsonUtils;
    private GetQueryFromJSONHelper _getQueryFromJSONHelper;
    private QueryBuilder _queryBuilder;
    private I18nUtils _i18nUtils;
    private ContentTypeExtensionPoint _contentTypeExtensionPoint;
    private SearchUIModelExtensionPoint _searchUIModelExtensionPoint;
    private CurrentUserProvider _currentUserProvider;
    private UserManager _userManager;
    private UserLanguagesManager _userLanguagesManager;

    public void service(ServiceManager serviceManager) throws ServiceException {
        this._thesaurusDAO = (ThesaurusDAO)serviceManager.lookup(ThesaurusDAO.ROLE);
        this._resolver = (AmetysObjectResolver)serviceManager.lookup(AmetysObjectResolver.ROLE);
        this._jsonUtils = (JSONUtils)serviceManager.lookup(JSONUtils.ROLE);
        this._getQueryFromJSONHelper = (GetQueryFromJSONHelper)serviceManager.lookup(GetQueryFromJSONHelper.ROLE);
        this._queryBuilder = (QueryBuilder)serviceManager.lookup(QueryBuilder.ROLE);
        this._i18nUtils = (I18nUtils)serviceManager.lookup(I18nUtils.ROLE);
        this._contentTypeExtensionPoint = (ContentTypeExtensionPoint)serviceManager.lookup(ContentTypeExtensionPoint.ROLE);
        this._searchUIModelExtensionPoint = (SearchUIModelExtensionPoint)serviceManager.lookup(SearchUIModelExtensionPoint.ROLE);
        this._currentUserProvider = (CurrentUserProvider)serviceManager.lookup(CurrentUserProvider.ROLE);
        this._userManager = (UserManager)serviceManager.lookup(UserManager.ROLE);
        this._userLanguagesManager = (UserLanguagesManager)serviceManager.lookup(UserLanguagesManager.ROLE);
    }

    @Callable(rights={"Extraction_Rights_EditExtraction"})
    public Map<String, Object> getNodeEditionConfiguration() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Set searchUIModelIds = this._searchUIModelExtensionPoint.getExtensionsIds();
        ArrayList searchUIModelsConfigurations = new ArrayList();
        for (String searchUIModelId : searchUIModelIds) {
            HashMap<String, String> searchUIModelMap = new HashMap<String, String>();
            searchUIModelMap.put("value", searchUIModelId);
            searchUIModelMap.put("label", searchUIModelId);
            searchUIModelsConfigurations.add(searchUIModelMap);
        }
        result.put("searchUIModels", searchUIModelsConfigurations);
        AmetysObjectIterable thesaurii = this._thesaurusDAO.getThesaurii();
        ArrayList thesauriiConfigurations = new ArrayList();
        for (Thesaurus thesaurus : thesaurii) {
            HashMap<String, String> thesaurusMap = new HashMap<String, String>();
            thesaurusMap.put("value", thesaurus.getId());
            thesaurusMap.put("label", thesaurus.getLabel());
            thesauriiConfigurations.add(thesaurusMap);
        }
        result.put("thesaurii", thesauriiConfigurations);
        return result;
    }

    @Callable(rights={"Extraction_Rights_EditExtraction"})
    public Map<String, Object> getMicroThesaurii(String thesaurusId) {
        String thesaurusLabel;
        Thesaurus thesaurus;
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (thesaurusId != null && (thesaurus = this._thesaurusDAO.findThesaurusByLabel(thesaurusLabel = this._thesaurusDAO.getThesaurusLabel(thesaurusId))) != null) {
            User user;
            List microthesaurii = this._thesaurusDAO.getMicrothesaurii(thesaurus.getId());
            String language = this._userLanguagesManager.getDefaultLanguage();
            UserIdentity userIdentity = this._currentUserProvider.getUser();
            if (userIdentity != null && (user = this._userManager.getUser(userIdentity)) != null) {
                language = user.getLanguage();
            }
            ArrayList microthesauriiConfigurations = new ArrayList();
            for (String microthesaurus : microthesaurii) {
                I18nizableText i18nLabel = ((ContentType)this._contentTypeExtensionPoint.getExtension(microthesaurus)).getLabel();
                String label = this._i18nUtils.translate((I18nizable)i18nLabel, language);
                HashMap<String, String> thesaurusMap = new HashMap<String, String>();
                thesaurusMap.put("value", microthesaurus);
                thesaurusMap.put("text", label);
                microthesauriiConfigurations.add(thesaurusMap);
            }
            result.put("microthesaurii", microthesauriiConfigurations);
        }
        return result;
    }

    @Callable(rights={"Extraction_Rights_EditExtraction"})
    public List<String> getSavedQueryContentTypes(String savedQueryId) {
        ArrayList<String> result = new ArrayList<String>();
        if (savedQueryId != null && !savedQueryId.isEmpty()) {
            Query referencedQuery = (Query)this._resolver.resolveById(savedQueryId);
            Map contentMap = this._jsonUtils.convertJsonToMap(referencedQuery.getContent());
            Map exportParams = (Map)contentMap.get("exportParams");
            String modelId = (String)exportParams.get("model");
            if (modelId.contains("solr")) {
                Map values = (Map)exportParams.get("values");
                result.addAll((List)values.get("contentTypes"));
            } else {
                SearchModel model = this._getQueryFromJSONHelper.getSearchModel(exportParams);
                Map contextualParameters = Optional.ofNullable((Map)exportParams.get("contextualParameters")).orElseGet(HashMap::new);
                Map values = (Map)exportParams.get("values");
                String searchMode = Objects.toString(exportParams.get("searchMode"), "simple");
                org.ametys.cms.search.query.Query query = this._queryBuilder.build(model, searchMode, values, contextualParameters);
                if (query instanceof AndQuery) {
                    LinkedHashSet subqueries = new LinkedHashSet(((AndQuery)query).getQueries());
                    Predicate<org.ametys.cms.search.query.Query> isCTypeOrMixinOrBothQuery = q -> ContentTypeQuery.class.isInstance(q) || MixinTypeQuery.class.isInstance(q) || ContentTypeOrMixinTypeQuery.class.isInstance(q);
                    List matchingQueries = subqueries.stream().distinct().filter(isCTypeOrMixinOrBothQuery).collect(Collectors.toList());
                    for (org.ametys.cms.search.query.Query matchingQuery : matchingQueries) {
                        ContentTypeOrMixinTypeQuery cTypeOrMixinQuery;
                        if (matchingQuery instanceof ContentTypeQuery) {
                            ContentTypeQuery cTypeQuery = (ContentTypeQuery)matchingQuery;
                            if (cTypeQuery.getOperator() != Query.Operator.EQ) continue;
                            result.addAll((Collection)cTypeQuery.getValue());
                            continue;
                        }
                        if (matchingQuery instanceof MixinTypeQuery) {
                            MixinTypeQuery mixinQuery = (MixinTypeQuery)matchingQuery;
                            if (mixinQuery.getOperator() != Query.Operator.EQ) continue;
                            result.addAll((Collection)mixinQuery.getValue());
                            continue;
                        }
                        if (!(matchingQuery instanceof ContentTypeOrMixinTypeQuery) || (cTypeOrMixinQuery = (ContentTypeOrMixinTypeQuery)matchingQuery).getOperator() != Query.Operator.EQ) continue;
                        result.addAll(cTypeOrMixinQuery.getIds());
                    }
                }
            }
        }
        return result;
    }
}

