/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.extraction.edition;

import java.io.IOException;
import java.util.Map;
import org.ametys.core.file.FileHelper;
import org.ametys.core.ui.Callable;
import org.ametys.core.ui.StaticClientSideElement;
import org.ametys.plugins.extraction.execution.ExtractionDAO;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.TraversableSource;
import org.apache.excalibur.source.impl.FileSource;

public class FoldersClientSideElement
extends StaticClientSideElement {
    private FileHelper _fileHelper;
    private SourceResolver _srcResolver;
    private ExtractionDAO _extractionDAO;

    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._fileHelper = (FileHelper)serviceManager.lookup(FileHelper.ROLE);
        this._srcResolver = (SourceResolver)serviceManager.lookup(SourceResolver.ROLE);
        this._extractionDAO = (ExtractionDAO)((Object)serviceManager.lookup(ExtractionDAO.ROLE));
    }

    @Callable(rights={"Extraction_Rights_EditExtraction"})
    public Map<String, Object> addFolder(String parentRelPath, String name) throws IOException {
        String parentURI;
        Map result;
        String nonNullParentRelPath = StringUtils.defaultString((String)parentRelPath);
        FileSource rootDir = (FileSource)this._srcResolver.resolveURI("context://WEB-INF/param/extraction/definitions/");
        if (!rootDir.exists()) {
            rootDir.getFile().mkdirs();
        }
        if ((result = this._fileHelper.addFolder(parentURI = "context://WEB-INF/param/extraction/definitions/" + (String)(StringUtils.isNotEmpty((CharSequence)nonNullParentRelPath) ? "/" + nonNullParentRelPath : ""), name, true)).containsKey("uri")) {
            String folderUri = (String)result.get("uri");
            String path = StringUtils.substringAfter((String)folderUri, (String)rootDir.getURI());
            result.put("path", ExtractionDAO.trimLastFileSeparator(path));
            result.put("parentPath", ExtractionDAO.trimLastFileSeparator(nonNullParentRelPath));
        }
        return result;
    }

    @Callable(rights={"Extraction_Rights_EditExtraction"})
    public Map<String, Object> deleteFile(String relPath) throws IOException {
        String fileUri = "context://WEB-INF/param/extraction/definitions/" + (String)(relPath.length() > 0 ? "/" + relPath : "");
        String context = "/extraction-dir/" + relPath;
        FileSource folderToDelete = (FileSource)this._srcResolver.resolveURI(fileUri);
        this._extractionDAO.deleteRightsRecursively(context, (TraversableSource)folderToDelete);
        return this._fileHelper.deleteFile(fileUri);
    }

    @Callable(rights={"Extraction_Rights_EditExtraction"})
    public Map<String, Object> renameFile(String relPath, String name) throws IOException {
        String fileUri = "context://WEB-INF/param/extraction/definitions/" + relPath;
        FileSource file = (FileSource)this._srcResolver.resolveURI(fileUri);
        String relativeParentPath = StringUtils.removeEnd((String)relPath, (String)file.getName());
        String relativeNewFilePath = relativeParentPath + name;
        return this._extractionDAO.moveOrRenameExtractionDefinitionFile(relPath, relativeNewFilePath);
    }
}

