/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.extraction.execution;

import java.nio.file.Path;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import org.ametys.cms.schedule.AbstractDeleteFilesSchedulable;
import org.ametys.core.right.RightManager;
import org.ametys.core.schedule.progression.ContainerProgressionTracker;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.runtime.util.AmetysHomeHelper;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;

public class DeleteExtractionsSchedulable
extends AbstractDeleteFilesSchedulable
implements Initializable {
    public static final String LIFETIME_KEY = "lifetime";
    private static final String __JOBDATAMAP_LIFETIME_KEY = "parameterValues#lifetime";
    protected RightManager _rightManager;
    protected CurrentUserProvider _currentUserProvider;
    private Path _rootPath;

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._rightManager = (RightManager)manager.lookup(RightManager.ROLE);
        this._currentUserProvider = (CurrentUserProvider)manager.lookup(CurrentUserProvider.ROLE);
    }

    public void initialize() throws Exception {
        this._rootPath = AmetysHomeHelper.getAmetysHomeData().toPath().resolve("extraction");
    }

    public void execute(JobExecutionContext context, ContainerProgressionTracker progressionTracker) throws Exception {
        UserIdentity user = this._currentUserProvider.getUser();
        if (this._rightManager.hasRight(user, "Extraction_Rights_EditExtraction", (Object)"/${WorkspaceName}") != RightManager.RightResult.RIGHT_ALLOW) {
            throw new IllegalStateException("User " + String.valueOf(user) + " try to delete extractions with no sufficient rights");
        }
        super.execute(context, progressionTracker);
    }

    protected AbstractDeleteFilesSchedulable.DeleteFilesConfiguration _getConfiguration(JobExecutionContext context) {
        AbstractDeleteFilesSchedulable.DeleteFilesConfiguration configuration = new AbstractDeleteFilesSchedulable.DeleteFilesConfiguration(this._rootPath);
        JobDataMap jobDataMap = context.getJobDetail().getJobDataMap();
        long lifetime = jobDataMap.getLong(__JOBDATAMAP_LIFETIME_KEY);
        configuration.setAgeLimit(Instant.now().minus(lifetime, ChronoUnit.DAYS));
        return configuration;
    }
}

