/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.extraction.execution;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.ametys.core.schedule.Runnable;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.util.JSONUtils;
import org.ametys.plugins.core.impl.schedule.DefaultRunnable;
import org.ametys.plugins.core.schedule.Scheduler;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.quartz.JobKey;
import org.quartz.SchedulerException;

public class ExecuteExtractionRunnableHelper
extends AbstractLogEnabled
implements Component,
Serviceable {
    public static final String ROLE = ExecuteExtractionRunnableHelper.class.getName();
    private static final String __RUNNABLE_PREFIX = "org.ametys.plugins.extraction.execution.ExecuteExtractionRunnable$";
    private JSONUtils _jsonUtils;
    private CurrentUserProvider _currentUserProvider;
    private Scheduler _scheduler;

    public void service(ServiceManager manager) throws ServiceException {
        this._jsonUtils = (JSONUtils)manager.lookup(JSONUtils.ROLE);
        this._currentUserProvider = (CurrentUserProvider)manager.lookup(CurrentUserProvider.ROLE);
        this._scheduler = (Scheduler)manager.lookup(Scheduler.ROLE);
    }

    public Map<String, Object> executeExtraction(String definitionFilePath, Map<String, Object> variables, String recipient, String pipelineId) {
        try {
            HashMap<String, String> jobParams = new HashMap<String, String>();
            jobParams.put("definitionFilePath", definitionFilePath);
            jobParams.put("variables", this._jsonUtils.convertObjectToJson(variables));
            jobParams.put("recipient", recipient);
            jobParams.put("pipeline", pipelineId);
            DefaultRunnable executeExtractionRunnable = new DefaultRunnable(__RUNNABLE_PREFIX + definitionFilePath, new I18nizableText("plugin.extraction", "PLUGINS_EXTRACTION_EXECUTE_EXTRACTION_SCHEDULABLE_LABEL", Collections.singletonList(definitionFilePath)), new I18nizableText("plugin.extraction", "PLUGINS_EXTRACTION_EXECUTE_EXTRACTION_SCHEDULABLE_DESCRIPTION", Collections.singletonList(definitionFilePath)), Runnable.FireProcess.NOW, null, "org.ametys.plugins.extraction.execution.ExecuteExtractionSchedulable", true, true, false, null, false, this._currentUserProvider.getUser(), jobParams);
            JobKey jobKey = new JobKey(executeExtractionRunnable.getId(), "runtime.job");
            if (this._scheduler.getScheduler().checkExists(jobKey)) {
                this._scheduler.getScheduler().deleteJob(jobKey);
            }
            this._scheduler.scheduleJob((Runnable)executeExtractionRunnable);
            this.getLogger().info("Scheduled extraction execution of " + definitionFilePath);
            return Map.of("definitionFilePath", definitionFilePath);
        }
        catch (SchedulerException e) {
            this.getLogger().error("An error occured when trying to schedule the extraction execution of " + definitionFilePath, (Throwable)e);
            return Map.of("error", "scheduler-error");
        }
    }

    public void deleteRunnableJob(String definitionFilePath) {
        try {
            String runnableId = __RUNNABLE_PREFIX + definitionFilePath;
            JobKey jobKey = new JobKey(runnableId, "runtime.job");
            if (this._scheduler.getScheduler().checkExists(jobKey)) {
                this._scheduler.getScheduler().deleteJob(jobKey);
            }
        }
        catch (SchedulerException e) {
            this.getLogger().error("An error occured when trying to remove the scheduled task of extraction execution of " + definitionFilePath, (Throwable)e);
        }
    }
}

