/*
 *  Copyright 2023 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This class is the data model for extraction result file entries.
 * @private
 */
Ext.define('Ametys.plugins.extraction.execution.ExtractionResultFileNode', {
    extend: 'Ametys.file.AbstractFileExplorerTree.FileNode',
    
    /**
     * @property {Object} fields Data structure of the extraction result file entries
     * @property {String} fields.downloadUrl Download URL of entry
     * @private
     */
    fields: [
        {name: 'downloadUrl'}
    ]
});