/*
 *  Copyright 2024 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

Ext.define('Ametys.plugins.extraction.rights.ExtractionTargetToContextConvertor', {
    extend: 'Ametys.plugins.coreui.rights.AbstractTargetToContextConvertor',
    
    statics:
    {
        /**
         * @readonly
         * @property {Object} EXTRACTION_ROOT_CONTEXT The root context for extraction definition.
         */
        EXTRACTION_ROOT_CONTEXT: '/extraction-dir',
    },

    isSupportedTarget: function(target)
    {
        return target != null
        && (target.getId() == Ametys.message.MessageTarget.EXTRACTION_DEFINITION_FILE
            || target.getId() == Ametys.message.MessageTarget.EXTRACTION_DEFINITION_ROOT
            || target.getId() == Ametys.message.MessageTarget.EXTRACTION_DEFINITION_FOLDER);
    },
    
    areSameTargets: function(target1, target2)
    {
        return target1.getParameters().path == target2.getParameters().path;
    },
    
    convert: function(target)
    {
        return Ametys.plugins.extraction.rights.ExtractionTargetToContextConvertor.EXTRACTION_ROOT_CONTEXT
         + (target.getParameters().path ? ("/" + target.getParameters().path) : "");
    },
    
    getContextInfo:function(target)
    {
        switch (target.getId())
        {
            case Ametys.message.MessageTarget.EXTRACTION_DEFINITION_ROOT:
                return {label: `{{i18n PLUGINS_EXTRACTION_TARGET_CONVERTOR_ROOT_LABEL}}`, type: `{{i18n PLUGINS_EXTRACTION_TARGET_CONVERTOR_FOLDER_TYPE_LABEL}}`}
            case Ametys.message.MessageTarget.EXTRACTION_DEFINITION_FOLDER:
                return {label: target.getParameters().name, type: `{{i18n PLUGINS_EXTRACTION_TARGET_CONVERTOR_FOLDER_TYPE_LABEL}}`}
            case Ametys.message.MessageTarget.EXTRACTION_DEFINITION_FILE:
            default:
                return {label: target.getParameters().name, type: `{{i18n PLUGINS_EXTRACTION_TARGET_CONVERTOR_FILE_TYPE_LABEL}}`}
                
        }
    }
});

