/*
 *  Copyright 2017 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.extraction.component;

import java.util.List;
import java.util.Map;
import java.util.Set;

import org.xml.sax.ContentHandler;

import org.ametys.plugins.extraction.execution.ExtractionExecutionContext;

/**
 * This interface represents a component of the extraction module
 */
public interface ExtractionComponent
{
    /**
     * Prepare the execution of the component
     * @param context context of the extraction component
     * @throws Exception if an error occurs
     */
    public void prepareComponentExecution(ExtractionExecutionContext context) throws Exception;
    
    /**
     * Execute the extraction of the component
     * @param contentHandler result document
     * @param context context of the extraction component
     * @throws Exception if an error occurs
     */
    public void execute(ContentHandler contentHandler, ExtractionExecutionContext context) throws Exception;
    
    /**
     * Add sub component
     * @param subComponent the sub components to add
     */
    public void addSubComponent(ExtractionComponent subComponent);
    
    /**
     * Retrieves sub components of the component
     * @return a list of sub components
     */
    public List<ExtractionComponent> getSubComponents();
    
    /**
     * Retrieves the list of content types defined for this component
     * @return a list of content types id
     */
    public Set<String> getContentTypes();
    
    /**
     * Retrieves the details of the component for tree
     * @return a <code>Map</code> containing component details
     */
    public Map<String, Object> getComponentDetailsForTree();
}
