/*
 *  Copyright 2017 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.extraction.execution;

import org.ametys.cms.repository.Content;
import org.ametys.plugins.extraction.component.ExtractionComponent;

/**
 * Context element for nested extraction component
 */
public class ExtractionExecutionContextHierarchyElement
{
    private ExtractionComponent _component;
    private Iterable<Content> _contents;
    private boolean _autoposting;
    
    /**
     * Constructor using element fields
     * @param component context component
     * @param contents context contents
     */
    public ExtractionExecutionContextHierarchyElement(ExtractionComponent component, Iterable<Content> contents)
    {
        this(component, contents, true);
    }
    
    /**
     * Constructor using all element fields
     * @param component context component
     * @param contents context contents
     * @param autoposting true if the content had to be autoposted, false otherwise
     */
    public ExtractionExecutionContextHierarchyElement(ExtractionComponent component, Iterable<Content> contents, boolean autoposting)
    {
        super();
        _component = component;
        _contents = contents;
        _autoposting = autoposting;
    }

    /**
     * Retrieves the context element's component
     * @return the context element's component
     */
    public ExtractionComponent getComponent()
    {
        return _component;
    }
    
    /**
     * Retrieves the context hierarchy element's contents
     * @return the context hierarchy element's contents
     */
    public Iterable<Content> getContents()
    {
        return _contents;
    }
    
    /**
     * the contents have to be autoposted
     * @return true if the contents have to be autoposted, false otherwise
     */
    public boolean isAutoposting()
    {
        return _autoposting;
    }
}
