/*
 *  Copyright 2018 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.extraction.execution.pipeline.impl;

import java.io.Closeable;

import org.ametys.plugins.extraction.execution.pipeline.Pipeline;

/**
 * A serializer for a {@link Pipeline}.
 * <br>Must be {@link #close() closed}.
 */
public interface PipelineSerializer extends Closeable
{
    /**
     * Prepares this serializer.
     * @throws Exception if an error occured
     */
    void prepare() throws Exception;
    
    /**
     * Does the serialization.
     * <br>{@link #prepare()} method must have been called before.
     * <br>Then, the pipeline must be {@link #close() closed}.
     * @throws Exception if an error occured
     */
    void serialize() throws Exception;
}
