/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.flipbook;

import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ametys.cms.repository.Content;
import org.ametys.core.util.FilenameUtils;
import org.ametys.plugins.explorer.resources.Resource;
import org.ametys.plugins.flipbook.AbstractConvertDocument2ImagesComponent;
import org.apache.commons.codec.digest.DigestUtils;

public class ConvertContentAttachment2ImagesComponent
extends AbstractConvertDocument2ImagesComponent {
    public static final String ROLE = ConvertContentAttachment2ImagesComponent.class.getName();
    private static final Pattern __ATTACHMENTS_PATTERN = Pattern.compile("^.*/ametys-internal:sites/([^/]+)/ametys-internal:contents/([^/]+)/ametys-internal:attachments/(.*)$");

    public String doCache(Resource resource, String contentName, String siteName) throws Exception {
        String cachePath = this._getCacheDirectory(resource.getResourcePath(), contentName, siteName);
        try (InputStream is = resource.getInputStream();){
            String string;
            block12: {
                InputStream is2 = resource.getInputStream();
                try {
                    String md5sum = DigestUtils.md5Hex((InputStream)is);
                    string = this.cache(cachePath, md5sum, is2, resource.getName(), resource.getId(), resource.getMimeType());
                    if (is2 == null) break block12;
                }
                catch (Throwable throwable) {
                    if (is2 != null) {
                        try {
                            is2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                is2.close();
            }
            return string;
        }
    }

    private String _getCacheDirectory(String resourcePath, String contentName, String siteName) {
        StringBuilder buff = this._getContentAttachmentsCacheDirectory(contentName, siteName);
        buff.append(FilenameUtils.encodePath((String)resourcePath));
        return buff.toString();
    }

    private StringBuilder _getContentAttachmentsCacheDirectory(String contentName, String siteName) {
        StringBuilder buff = new StringBuilder();
        buff.append("/");
        buff.append(siteName);
        buff.append("/contents/");
        buff.append(contentName);
        buff.append("/attachments");
        return buff;
    }

    public void doCleanCache(Content content, String siteName) {
        this.cleanCache(this._getContentAttachmentsCacheDirectory(content.getName(), siteName).toString());
    }

    public void doCleanCache(String path) {
        Matcher attachmentMatcher = __ATTACHMENTS_PATTERN.matcher(path);
        if (attachmentMatcher.matches()) {
            this.cleanCache(this._getCacheDirectory("/" + attachmentMatcher.group(3), attachmentMatcher.group(2), attachmentMatcher.group(1)));
        }
    }
}

