/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.flipbook;

import java.io.InputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.ametys.cms.data.Binary;
import org.ametys.cms.repository.Content;
import org.ametys.core.util.FilenameUtils;
import org.ametys.plugins.flipbook.AbstractConvertDocument2ImagesComponent;
import org.ametys.plugins.repository.data.holder.group.ModelAwareRepeater;
import org.apache.commons.codec.digest.DigestUtils;

public class ConvertMetadata2ImagesComponent
extends AbstractConvertDocument2ImagesComponent {
    public static final String ROLE = ConvertMetadata2ImagesComponent.class.getName();

    public String doCache(Content content, String metadataPath, String siteName) throws Exception {
        Binary binary = this._getBinary(metadataPath, content);
        String cachePath = this._getCacheDirectory(metadataPath, binary.getFilename(), content.getName(), siteName);
        try (InputStream is = binary.getInputStream();){
            String string;
            block12: {
                InputStream is2 = binary.getInputStream();
                try {
                    String md5sum = DigestUtils.md5Hex((InputStream)is);
                    string = this.cache(cachePath, md5sum, is2, content.getName(), content.getId(), binary.getMimeType());
                    if (is2 == null) break block12;
                }
                catch (Throwable throwable) {
                    if (is2 != null) {
                        try {
                            is2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                is2.close();
            }
            return string;
        }
    }

    private Binary _getBinary(String dataPath, Content content) {
        if (dataPath.contains("[")) {
            return (Binary)content.getValue(dataPath);
        }
        List<String> pathSegments = Arrays.asList(dataPath.split("/"));
        Iterator<String> pathSegmentsIt = pathSegments.iterator();
        Content dataHolder = content;
        Binary binary = null;
        while (pathSegmentsIt.hasNext()) {
            String pathSegment = pathSegmentsIt.next();
            if (pathSegmentsIt.hasNext()) {
                if (dataHolder.getType(pathSegment).getId().equals("repeater")) {
                    ModelAwareRepeater repeater = dataHolder.getRepeater(pathSegment);
                    int repeaterPosition = Integer.valueOf(pathSegmentsIt.next());
                    dataHolder = repeater.getEntry(repeaterPosition);
                    continue;
                }
                dataHolder = dataHolder.getComposite(pathSegment);
                continue;
            }
            binary = (Binary)dataHolder.getValue(pathSegment);
        }
        return binary;
    }

    private String _getCacheDirectory(String metadataPath, String fileName, String contentName, String siteName) {
        StringBuilder buff = this._getContentCacheDirectory(contentName, siteName);
        buff.append("/metadatas/");
        buff.append(metadataPath);
        buff.append("/");
        buff.append(FilenameUtils.encodeName((String)fileName));
        return buff.toString();
    }

    private StringBuilder _getContentCacheDirectory(String contentName, String siteName) {
        StringBuilder buff = new StringBuilder();
        buff.append("/");
        buff.append(siteName);
        buff.append("/contents/");
        buff.append(contentName);
        return buff;
    }

    public void doCleanCache(Content content, String siteName) {
        this.cleanCache(this._getContentCacheDirectory(content.getName(), siteName).toString() + "/metadatas");
    }
}

