/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.flipbook;

import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ametys.core.util.FilenameUtils;
import org.ametys.plugins.explorer.resources.Resource;
import org.ametys.plugins.flipbook.AbstractConvertDocument2ImagesComponent;
import org.apache.commons.codec.digest.DigestUtils;

public class ConvertResource2ImagesComponent
extends AbstractConvertDocument2ImagesComponent {
    public static final String ROLE = ConvertResource2ImagesComponent.class.getName();
    private static final Pattern __RESOURCE_PATTERN = Pattern.compile("^.*/ametys-internal:sites/([^/]+)/ametys-internal:resources/(.*)$");
    private static final Pattern __ROOT_SITE_RESOURCE_PATTERN = Pattern.compile("^.*/ametys-internal:sites/[^/]+/[^/]+/([^/]+)/ametys-internal:resources/(.*)$");
    private static final Pattern __SHARED_RESOURCE_PATTERN = Pattern.compile("^.*/ametys:plugins/web-explorer/shared-resources/(.*)$");

    public String doCache(Resource resource, String siteName) throws Exception {
        String cachePath = this._getCacheDirectory(resource, siteName);
        try (InputStream is = resource.getInputStream();){
            String string;
            block12: {
                InputStream is2 = resource.getInputStream();
                try {
                    String md5sum = DigestUtils.md5Hex((InputStream)is);
                    string = this.cache(cachePath, md5sum, is2, resource.getName(), resource.getId(), resource.getMimeType());
                    if (is2 == null) break block12;
                }
                catch (Throwable throwable) {
                    if (is2 != null) {
                        try {
                            is2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                is2.close();
            }
            return string;
        }
    }

    private String _getCacheDirectory(Resource resource, String siteName) {
        String fullPath = resource.getPath();
        if (fullPath.startsWith("/ametys:plugins/web-explorer/shared-resources")) {
            return "/shared-resources" + FilenameUtils.encodePath((String)fullPath.substring("/ametys:plugins/web-explorer/shared-resources".length()));
        }
        StringBuilder buff = new StringBuilder();
        buff.append("/");
        buff.append(siteName);
        buff.append("/resources");
        buff.append(FilenameUtils.encodePath((String)resource.getResourcePath()));
        return buff.toString();
    }

    public void doCleanCache(String path, String resourcePath) {
        Matcher resourceMatcher = __RESOURCE_PATTERN.matcher(path);
        Matcher rootSiteResourceMatcher = __ROOT_SITE_RESOURCE_PATTERN.matcher(path);
        Matcher sharedMatcher = __SHARED_RESOURCE_PATTERN.matcher(path);
        String cachePath = null;
        if (resourceMatcher.matches()) {
            cachePath = "/" + resourceMatcher.group(1) + "/resources" + FilenameUtils.encodePath((String)resourcePath);
        } else if (rootSiteResourceMatcher.matches()) {
            cachePath = "/" + rootSiteResourceMatcher.group(1) + "/resources" + FilenameUtils.encodePath((String)resourcePath);
        } else if (sharedMatcher.matches()) {
            cachePath = "/shared-resources" + FilenameUtils.encodePath((String)path.substring("/ametys:plugins/web-explorer/shared-resources".length()));
        }
        if (cachePath != null) {
            this.cleanCache(cachePath);
        }
    }
}

