/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.flipbook;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import javax.imageio.ImageIO;
import org.ametys.core.util.URIUtils;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ImagesGenerator
extends ServiceableGenerator {
    public static final String IMAGES_DIRECTORY_PATH_REQUEST_ATTR = "images-base-directory";
    protected AmetysObjectResolver _resolver;

    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._resolver = (AmetysObjectResolver)serviceManager.lookup(AmetysObjectResolver.ROLE);
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        String basePath = (String)request.getAttribute(IMAGES_DIRECTORY_PATH_REQUEST_ATTR);
        File documentFolder = new File(basePath, "/document");
        Iterator documentFiles = FileUtils.listFiles((File)documentFolder, (String[])new String[]{"document"}, (boolean)false).iterator();
        File documentFile = documentFiles.hasNext() ? (File)documentFiles.next() : null;
        File imageFolder = new File(basePath + "/pages");
        ArrayList imageFiles = new ArrayList(FileUtils.listFiles((File)imageFolder, (String[])new String[]{"png"}, (boolean)false));
        Collections.sort(imageFiles);
        this.contentHandler.startDocument();
        String relPath = URIUtils.encodePath((String)StringUtils.substringAfter((String)basePath, (String)"flipbook"));
        AttributesImpl attrs = new AttributesImpl();
        attrs.addCDATAAttribute("basePath", relPath);
        attrs.addCDATAAttribute("pagePath", relPath + "/pages");
        if (documentFile != null) {
            attrs.addCDATAAttribute("documentPath", relPath + "/document");
            attrs.addCDATAAttribute("documentName", documentFile.getName());
            attrs.addCDATAAttribute("documentSize", Long.toString(documentFile.length()));
        }
        attrs.addCDATAAttribute("nb-page", String.valueOf(imageFiles.size()));
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"images", (Attributes)attrs);
        for (File file : imageFiles) {
            BufferedImage image = ImageIO.read(file);
            int width = image.getWidth();
            int height = image.getHeight();
            float ratio = (float)width / (float)height;
            AttributesImpl pageAttrs = new AttributesImpl();
            pageAttrs.addCDATAAttribute("fileName", file.getName());
            pageAttrs.addCDATAAttribute("width", Integer.toString(width));
            pageAttrs.addCDATAAttribute("height", Integer.toString(height));
            pageAttrs.addCDATAAttribute("ratio", Float.toString(ratio));
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"image", (Attributes)pageAttrs);
        }
        File previewFile = new File(imageFolder, "preview.jpg");
        if (previewFile.exists()) {
            BufferedImage bi = ImageIO.read(previewFile);
            AttributesImpl previewAttrs = new AttributesImpl();
            previewAttrs.addCDATAAttribute("name", previewFile.getName());
            previewAttrs.addCDATAAttribute("width", String.valueOf(bi.getWidth()));
            int rows = (int)Math.ceil(1 + imageFiles.size() / 2);
            previewAttrs.addCDATAAttribute("height", String.valueOf(bi.getHeight() / rows));
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"preview", (Attributes)previewAttrs);
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"images");
        this.contentHandler.endDocument();
    }
}

