/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.flipbook;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ametys.core.observation.Event;
import org.ametys.core.observation.Observer;
import org.ametys.core.util.FilenameUtils;
import org.ametys.core.util.URIUtils;
import org.ametys.plugins.explorer.resources.Resource;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.runtime.plugin.component.PluginAware;
import org.ametys.web.cache.CacheHelper;
import org.ametys.web.repository.site.SiteManager;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.slf4j.Logger;

public class InvalidateFlipbookCacheOnResourceUpdateObserver
extends AbstractLogEnabled
implements Observer,
PluginAware,
Serviceable {
    private static final Pattern __RESOURCE_PATTERN = Pattern.compile("^.*/ametys-internal:sites/([^/]+)/ametys-internal:resources/(.*)$");
    private static final Pattern __ROOT_SITE_RESOURCE_PATTERN = Pattern.compile("^.*/ametys-internal:sites/[^/]+/[^/]+/([^/]+)/ametys-internal:resources/(.*)$");
    private static final Pattern __SHARED_RESOURCE_PATTERN = Pattern.compile("^.*/ametys:plugins/web-explorer/shared-resources/(.*)$");
    private static final Pattern __ATTACHMENTS_PATTERN = Pattern.compile("^.*/ametys-internal:sites/([^/]+)/ametys-internal:contents/([^/]+)/ametys-internal:attachments/(.*)$");
    private String _pluginName;
    private SiteManager _siteManager;
    private AmetysObjectResolver _resolver;

    public void setPluginInfo(String pluginName, String featureName, String id) {
        this._pluginName = pluginName;
    }

    public void service(ServiceManager smanager) throws ServiceException {
        this._siteManager = (SiteManager)smanager.lookup(SiteManager.ROLE);
        this._resolver = (AmetysObjectResolver)smanager.lookup(AmetysObjectResolver.ROLE);
    }

    public boolean supports(Event event) {
        return event.getId().equals("resource.updated");
    }

    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    public void observe(Event event, Map<String, Object> transientVars) throws Exception {
        try {
            Map args = event.getArguments();
            String path = (String)args.get("object.path");
            String resourceId = (String)args.get("object.id");
            this._invalidate(path, resourceId);
        }
        catch (Exception e) {
            this.getLogger().error("Exception while trying to handle explorer event + " + String.valueOf(event), (Throwable)e);
        }
    }

    private void _invalidate(String path, String resourceId) throws Exception {
        Matcher matcher1 = __RESOURCE_PATTERN.matcher(path);
        Matcher matcher2 = __ROOT_SITE_RESOURCE_PATTERN.matcher(path);
        Matcher sharedMatcher = __SHARED_RESOURCE_PATTERN.matcher(path);
        Matcher attachmentMatcher = __ATTACHMENTS_PATTERN.matcher(path);
        String site = null;
        String prefix = null;
        Object bookPathInSite = null;
        Object pagePathInSite = null;
        String resourcePrefix = "resources";
        if (matcher1.matches()) {
            site = matcher1.group(1);
            pagePathInSite = bookPathInSite = FilenameUtils.encodePath((String)matcher1.group(2));
            prefix = "resource-flipbook";
        } else if (matcher2.matches()) {
            site = matcher2.group(1);
            pagePathInSite = bookPathInSite = FilenameUtils.encodePath((String)matcher2.group(2));
            prefix = "resource-flipbook";
        } else if (sharedMatcher.matches()) {
            pagePathInSite = bookPathInSite = FilenameUtils.encodePath((String)sharedMatcher.group(1));
            prefix = "shared-resource-flipbook";
            resourcePrefix = "shared-resources";
        } else if (attachmentMatcher.matches()) {
            site = attachmentMatcher.group(1);
            prefix = "attachments-flipbook";
            resourcePrefix = "contents";
            String contentName = attachmentMatcher.group(2);
            String resourcePath = FilenameUtils.encodePath((String)attachmentMatcher.group(3));
            bookPathInSite = contentName + "/" + resourcePath;
            Resource resource = (Resource)this._resolver.resolveById(resourceId);
            bookPathInSite = (String)bookPathInSite + "/_contents" + FilenameUtils.encodePath((String)resource.getPath());
            pagePathInSite = contentName + "/attachments/" + resourcePath;
        } else {
            this.getLogger().warn(path + " does not match attempted pattern for resources");
            return;
        }
        Collection siteNames = new ArrayList<String>();
        if (site != null) {
            siteNames.add(site);
        } else {
            siteNames = this._siteManager.getSiteNames();
        }
        for (String siteName : siteNames) {
            String fullPath = "_plugins/" + this._pluginName + "/" + siteName + "/_" + prefix + "/" + (String)bookPathInSite + "/book.html";
            CacheHelper.testWS((String)URIUtils.encodePath((String)("/_invalidate-page/" + siteName + "/" + fullPath)), (Logger)this.getLogger());
            fullPath = "_plugins/" + this._pluginName + (String)(site != null ? "/" + siteName : "") + "/" + resourcePrefix + "/" + (String)pagePathInSite + "/pages";
            CacheHelper.testWS((String)URIUtils.encodePath((String)("/_invalidate-page/" + siteName + "/" + fullPath)), (Logger)this.getLogger());
        }
    }
}

