/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.flipbook.pdfbox;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import net.coobird.thumbnailator.makers.FixedSizeThumbnailMaker;
import net.coobird.thumbnailator.resizers.DefaultResizerFactory;
import org.ametys.plugins.flipbook.Document2ImagesConvertorPolicy;
import org.ametys.plugins.flipbook.FlipbookException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPageTree;
import org.apache.pdfbox.rendering.ImageType;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.apache.pdfbox.tools.imageio.ImageIOUtil;

public class PdfboxConvertor
extends AbstractLogEnabled
implements Document2ImagesConvertorPolicy {
    @Override
    public void convert(File pdfFile, File folder) throws IOException, FlipbookException {
        String outputPrefix = "page";
        String imageFormat = "png";
        try (PDDocument document = PDDocument.load((File)pdfFile);){
            if (document.isEncrypted()) {
                throw new IOException("The PDF file is encrypted, cannot read it.");
            }
            long start = System.currentTimeMillis();
            if (this.getLogger().isInfoEnabled()) {
                this.getLogger().info("Converting PDF to PNG images using pdfbox.");
            }
            this.writeImages(document, folder, imageFormat, outputPrefix, 120);
            this.writePreview(folder, outputPrefix);
            long end = System.currentTimeMillis();
            if (this.getLogger().isInfoEnabled()) {
                this.getLogger().info("PDF converted to PNG in " + (end - start) + "ms.");
            }
        }
    }

    protected List<String> writeImages(PDDocument document, File folder, String imageFormat, String outputPrefix) throws IOException, FlipbookException {
        return this.writeImages(document, folder, imageFormat, outputPrefix, 96);
    }

    protected List<String> writeImages(PDDocument document, File folder, String imageFormat, String outputPrefix, int resolution) throws IOException, FlipbookException {
        return this.writeImages(document, folder, imageFormat, "", 1, Integer.MAX_VALUE, outputPrefix, ImageType.RGB, resolution, 1.0f);
    }

    protected List<String> writeImages(PDDocument document, File folder, String imageFormat, String password, int startPage, int endPage, String outputPrefix, ImageType imageType, int resolution, float quality) throws IOException, FlipbookException {
        ArrayList<String> fileNames = new ArrayList<String>();
        PDPageTree pageTree = document.getPages();
        int pageCount = pageTree.getCount();
        int digitCount = Integer.toString(pageCount).length();
        String format = "%0" + digitCount + "d." + imageFormat;
        for (int i = startPage - 1; i < endPage && i < pageCount; ++i) {
            PDFRenderer pdfRenderer = new PDFRenderer(document);
            BufferedImage image = pdfRenderer.renderImageWithDPI(i, (float)resolution, imageType);
            String fileName = outputPrefix + String.format(format, i + 1, imageFormat);
            fileNames.add(fileName);
            File imageFile = new File(folder, fileName + ".part");
            try (FileOutputStream os = new FileOutputStream(imageFile);){
                if (!ImageIOUtil.writeImage((BufferedImage)image, (String)imageFormat, (OutputStream)os, (int)resolution, (float)quality)) {
                    throw new FlipbookException("Unable to write PDF page " + i + " to " + imageFile.getAbsolutePath());
                }
            }
            imageFile.renameTo(new File(folder, fileName));
        }
        return fileNames;
    }

    @Override
    public List<String> getSupportedMimeTypes() {
        ArrayList<String> mimeTypeSupported = new ArrayList<String>();
        mimeTypeSupported.add("application/pdf");
        return mimeTypeSupported;
    }

    protected void writePreview(File folder, final String outputPrefix) throws IOException {
        File[] images = folder.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().startsWith(outputPrefix);
            }
        });
        File firstImage = images[0];
        BufferedImage bfi = ImageIO.read(firstImage);
        double imgRatio = (double)bfi.getHeight() / (double)bfi.getWidth();
        int rows = (int)Math.ceil(1 + images.length / 2);
        int imgWidthInPreview = 56;
        int imgHeightInPreview = (int)Math.round((double)imgWidthInPreview * imgRatio);
        BufferedImage result = new BufferedImage(imgWidthInPreview * 2, imgHeightInPreview * rows, 1);
        Graphics g = result.getGraphics();
        int x = 0;
        int y = 0;
        int count = 0;
        for (File image : images) {
            BufferedImage bi = ImageIO.read(image);
            BufferedImage ri = PdfboxConvertor._resizeImage(bi, imgHeightInPreview, imgWidthInPreview);
            g.drawImage(ri, x, y, null);
            if (count == 0 || (x += imgWidthInPreview) >= result.getWidth()) {
                x = 0;
                y += ri.getHeight();
            }
            ++count;
        }
        ImageIO.write((RenderedImage)result, "jpg", new File(folder, "preview.jpg"));
    }

    private static BufferedImage _resizeImage(BufferedImage src, int maxHeight, int maxWidth) {
        int srcHeight = src.getHeight();
        int srcWidth = src.getWidth();
        int destHeight = 0;
        int destWidth = 0;
        boolean keepAspectRatio = true;
        if (srcHeight <= maxHeight && srcWidth <= maxWidth || destHeight == srcHeight && destWidth == srcWidth) {
            return src;
        }
        destWidth = maxWidth;
        destHeight = maxHeight;
        Dimension srcDimension = new Dimension(srcWidth, srcHeight);
        Dimension thumbnailDimension = new Dimension(destWidth, destHeight);
        BufferedImage thumbImage = new FixedSizeThumbnailMaker(destWidth, destHeight, keepAspectRatio, true).resizer(DefaultResizerFactory.getInstance().getResizer(srcDimension, thumbnailDimension)).imageType(src.getColorModel().hasAlpha() ? 2 : 1).make(src);
        return thumbImage;
    }
}

