/*
 *  Copyright 2020 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.flipbook;

import org.ametys.core.resources.AbstractSimpleResourceHandlerProvider;
import org.ametys.core.resources.ResourceHandler;
import org.ametys.core.resources.ResourceHandlerProvider;

/**
 * {@link ResourceHandlerProvider} for images.
 */
public class PdfCoverResourceHandlerProvider extends AbstractSimpleResourceHandlerProvider
{
    @Override
    public int getPriority()
    {
        // Should be processed before the image resource handler
        return MIN_PRIORITY + 2000;
    }
    
    @Override
    protected ResourceHandler createResourceHandler(String source)
    {
        return new PdfCoverResourceHandler();
    }
}
