/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import org.ametys.core.ui.Callable;
import org.ametys.plugins.forms.dao.FormDAO;
import org.ametys.plugins.forms.repository.Form;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class FormAdminMailsHelper
extends AbstractLogEnabled
implements Serviceable,
Component {
    public static final String ROLE = FormAdminMailsHelper.class.getName();
    public static final String REGEX_MAIL = "^([a-zA-Z0-9_\\.\\-])+\\@(([a-zA-Z0-9\\-])+\\.)+([a-zA-Z0-9]{2,})$";
    protected AmetysObjectResolver _resolver;
    protected FormDAO _formDAO;

    public void service(ServiceManager manager) throws ServiceException {
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._formDAO = (FormDAO)((Object)manager.lookup(FormDAO.ROLE));
    }

    @Callable(rights={""})
    public Map<String, Object> getAdminEmails(String formId) {
        Form form = (Form)this._resolver.resolveById(formId);
        this._formDAO.checkHandleFormRight((AmetysObject)form);
        HashMap<String, Object> emailProperties = new HashMap<String, Object>();
        this._addOptionalProperty("admin-emails", form.getAdminEmails(), emailProperties, ArrayUtils.EMPTY_STRING_ARRAY);
        this._addOptionalProperty("admin-emails-other", form.getOtherAdminEmails(), emailProperties, "");
        this._addOptionalProperty("admin-emails-language", form.getAdminEmailLanguage(), emailProperties, null);
        this._addOptionalProperty("admin-email-subject", form.getAdminEmailSubject(), emailProperties, null);
        this._addOptionalProperty("admin-emails-body", form.getAdminEmailBody(), emailProperties, null);
        return emailProperties;
    }

    private void _addOptionalProperty(String propertyName, Optional<? extends Object> value, Map<String, Object> limitProperties, Object defaultValue) {
        if (value.isPresent()) {
            limitProperties.put(propertyName, value.get());
        } else if (defaultValue != null) {
            limitProperties.put(propertyName, defaultValue);
        }
    }

    @Callable(rights={""})
    public Map<String, Object> setAdminEmails(String formId, String emails, String receiver, String subject, String body, String language) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Form form = (Form)this._resolver.resolveById(formId);
        this._formDAO.checkHandleFormRight((AmetysObject)form);
        String[] emailsTab = emails.split("[ ,;\r]");
        List<String> computedEmails = this.getValidAdminEmails(emailsTab);
        if (!computedEmails.isEmpty() || StringUtils.isNotBlank((CharSequence)receiver)) {
            form.setAdminEmails(computedEmails.toArray(new String[computedEmails.size()]));
            if (StringUtils.isBlank((CharSequence)receiver) && form.hasValue("admin-emails-other")) {
                form.removeValue("admin-emails-other");
            }
            if (StringUtils.isNotBlank((CharSequence)receiver)) {
                form.setOtherAdminEmails(receiver);
            }
            form.setAdminEmailLanguage(language);
            form.setAdminEmailSubject(subject);
            form.setAdminEmailBody(body);
            form.saveChanges();
        } else {
            this.getLogger().error("Mails addresses were undefined or not valid");
            result.put("message", "invalid-address");
        }
        return result;
    }

    @Callable(rights={""})
    public Map<String, Object> removeAdminEmails(String formId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Form form = (Form)this._resolver.resolveById(formId);
        this._formDAO.checkHandleFormRight((AmetysObject)form);
        if (form.getAdminEmails().isPresent() || form.getOtherAdminEmails().isPresent()) {
            if (form.getAdminEmails().isPresent()) {
                form.removeValue("admin-emails");
            }
            if (form.getOtherAdminEmails().isPresent()) {
                form.removeValue("admin-emails-other");
            }
            form.removeValue("admin-email-subject");
            form.removeValue("admin-emails-body");
            form.saveChanges();
        }
        return result;
    }

    public List<String> getValidAdminEmails(String[] emailsTab) {
        Pattern pattern = Pattern.compile(REGEX_MAIL);
        ArrayList<String> computedEmails = new ArrayList<String>();
        boolean error = false;
        for (String mail : emailsTab) {
            String trimMail = mail.trim();
            if (!StringUtils.isNotBlank((CharSequence)trimMail)) continue;
            if (pattern.matcher(trimMail).matches()) {
                computedEmails.add(trimMail);
                continue;
            }
            error = true;
            this.getLogger().error("Mail address " + mail + " did not match regex");
        }
        return error ? ListUtils.EMPTY_LIST : computedEmails;
    }
}

