/*
 *  Copyright 2021 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.forms.question.types.impl;

import java.util.Collections;
import java.util.List;
import java.util.Map;

import org.ametys.plugins.forms.question.types.AbstractFormQuestionType;
import org.ametys.plugins.forms.repository.FormQuestion;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.SimpleViewItemGroup;
import org.ametys.runtime.model.ViewElement;
import org.ametys.runtime.model.type.ModelItemTypeConstants;

/**
 * Class for creating check box question type
 */
public class CheckBoxQuestionType extends AbstractFormQuestionType
{
    /** Constant for default value attribute */
    public static final String ATTRIBUTE_IS_CHECKED = "is-checked";
    
    /** Constant for default title */
    public static final String DEFAULT_TITLE = "PLUGIN_FORMS_QUESTION_DEFAULT_TITLE_CHECKBOX";
    
    @Override
    protected List<ModelItem> _getModelItems()
    {
        List<ModelItem> modelItems = super._getModelItems();
        
        ElementDefinition<Boolean> checked = _formElementDefinitionHelper.getElementDefinition(ATTRIBUTE_IS_CHECKED, ModelItemTypeConstants.BOOLEAN_TYPE_ID, "PLUGINS_FORMS_QUESTIONS_DIALOG_BOOLEAN_DEFAULT_VALUE", "PLUGINS_FORMS_QUESTIONS_DIALOG_BOOLEAN_DEFAULT_VALUE_DESC", null);
        modelItems.add(checked);
        
        return modelItems;
    }

    @Override
    protected SimpleViewItemGroup _getMainTab()
    {
        SimpleViewItemGroup mainFieldset = super._getMainTab();
        
        ViewElement checked = new ViewElement();
        checked.setDefinition((ElementDefinition< ? >) getModel().getModelItem(ATTRIBUTE_IS_CHECKED));
        mainFieldset.addViewItem(checked);
        
        return mainFieldset;
    }
    
    public String getStorageType(FormQuestion question)
    {
        return ModelItemTypeConstants.BOOLEAN_TYPE_ID;
    }

    public I18nizableText getDefaultTitle()
    {
        return new I18nizableText("plugin.forms", DEFAULT_TITLE);
    }
    
    public Map<String, Object> getAnonymizedData(FormQuestion question)
    {
        // Use singleton map to support null
        return Collections.singletonMap(question.getNameForForm(), isMandatory(question) ? Boolean.FALSE : null);
    }
}
