/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.actions;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ametys.core.cocoon.JSonReader;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.forms.helper.FormStatisticsHelper;
import org.ametys.plugins.forms.helper.LimitedEntriesHelper;
import org.ametys.plugins.forms.helper.ScheduleOpeningHelper;
import org.ametys.plugins.forms.repository.Form;
import org.ametys.plugins.forms.repository.FormEntry;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;

public class GetDynamicFormInformationAction
extends ServiceableAction {
    protected AmetysObjectResolver _resolver;
    protected CurrentUserProvider _currentUserProvider;
    protected LimitedEntriesHelper _limitedEntriesHelper;
    protected FormStatisticsHelper _formStatsHelper;
    protected ScheduleOpeningHelper _scheduleOpeningHelper;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._resolver = (AmetysObjectResolver)smanager.lookup(AmetysObjectResolver.ROLE);
        this._currentUserProvider = (CurrentUserProvider)smanager.lookup(CurrentUserProvider.ROLE);
        this._limitedEntriesHelper = (LimitedEntriesHelper)((Object)smanager.lookup(LimitedEntriesHelper.ROLE));
        this._formStatsHelper = (FormStatisticsHelper)((Object)smanager.lookup(FormStatisticsHelper.ROLE));
        this._scheduleOpeningHelper = (ScheduleOpeningHelper)((Object)smanager.lookup(ScheduleOpeningHelper.ROLE));
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        String formId = parameters.getParameter("id", request.getParameter("id"));
        Form form = (Form)this._resolver.resolveById(formId);
        if (form.isMiniSurvey()) {
            List<FormEntry> entries = form.getEntries();
            result.put("nbEntries", entries.size());
            ScheduleOpeningHelper.FormStatus status = this._scheduleOpeningHelper.getStatus(form);
            result.put("status", status.name());
            String clientIp = this._limitedEntriesHelper.getClientIp(request);
            UserIdentity currentUser = this._currentUserProvider.getUser();
            boolean answered = this._limitedEntriesHelper.hasUserAlreadyAnswer(form, currentUser, clientIp);
            result.put("answered", answered);
            if (answered || ScheduleOpeningHelper.FormStatus.OVER == status) {
                result.put("results", this._formStatsHelper.getMiniSurveyStatistics(form.getId()));
            }
        } else {
            result.put("results", Map.of("error", "not-a-mini-survey"));
        }
        request.setAttribute(JSonReader.OBJECT_TO_READ, result);
        return EMPTY_MAP;
    }
}

