/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.actions;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.ametys.core.cocoon.JSonReader;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.core.util.I18nUtils;
import org.ametys.core.util.JSONUtils;
import org.ametys.plugins.core.user.UserHelper;
import org.ametys.plugins.forms.dao.FormEntryDAO;
import org.ametys.plugins.forms.helper.LimitedEntriesHelper;
import org.ametys.plugins.forms.question.types.impl.MatrixQuestionType;
import org.ametys.plugins.forms.repository.Form;
import org.ametys.plugins.forms.repository.FormEntry;
import org.ametys.plugins.forms.repository.FormQuestion;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.data.ametysobject.DataAwareAmetysObject;
import org.ametys.plugins.repository.model.RepositoryDataContext;
import org.ametys.plugins.workflow.support.WorkflowProvider;
import org.ametys.runtime.model.Model;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.type.DataContext;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.commons.lang3.StringUtils;

public class GetFormEntriesAction
extends ServiceableAction {
    public static final String QUEUE_STATUS = "queue-status";
    public static final String FORM_ENTRY_ACTIVE = "active";
    protected AmetysObjectResolver _resolver;
    protected FormEntryDAO _formEntryDAO;
    protected LimitedEntriesHelper _handleLimitedEntriesHelper;
    protected UserHelper _userHelper;
    protected UserManager _userManager;
    protected WorkflowProvider _workflowProvider;
    protected JSONUtils _jsonUtils;
    protected I18nUtils _i18nUtils;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._resolver = (AmetysObjectResolver)smanager.lookup(AmetysObjectResolver.ROLE);
        this._formEntryDAO = (FormEntryDAO)((Object)smanager.lookup(FormEntryDAO.ROLE));
        this._userHelper = (UserHelper)smanager.lookup(UserHelper.ROLE);
        this._userManager = (UserManager)smanager.lookup(UserManager.ROLE);
        this._workflowProvider = (WorkflowProvider)smanager.lookup(WorkflowProvider.ROLE);
        this._handleLimitedEntriesHelper = (LimitedEntriesHelper)((Object)smanager.lookup(LimitedEntriesHelper.ROLE));
        this._jsonUtils = (JSONUtils)smanager.lookup(JSONUtils.ROLE);
        this._i18nUtils = (I18nUtils)smanager.lookup(I18nUtils.ROLE);
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        Map jsParameters = (Map)objectModel.get("parent-context");
        String formId = (String)jsParameters.get("formId");
        Form form = (Form)this._resolver.resolveById(formId);
        if (form == null) {
            throw new ProcessingException("The form of ID '" + formId + " can't be found.");
        }
        this._formEntryDAO.checkHandleDataRight((AmetysObject)form);
        Integer offset = this._getIntValue(jsParameters, "start", 0);
        Integer limit = this._getIntValue(jsParameters, "limit", Integer.MAX_VALUE);
        String sortInfo = (String)jsParameters.get("sort");
        String groupInfo = (String)jsParameters.get("group");
        List<FormEntryDAO.Sort> sorts = this._getSorts(formId, sortInfo, groupInfo);
        Map<String, Object> matrixLabels = this._getMatrixInfos(form);
        HashMap<String, Serializable> result = new HashMap<String, Serializable>();
        ArrayList entries2json = new ArrayList();
        try {
            List<FormEntry> entries = this._getEntries(form, sorts);
            int totalSubmissions = entries.size();
            result.put("total", Integer.valueOf(totalSubmissions));
            for (int currentLimit = 0; currentLimit < limit && offset < totalSubmissions; ++currentLimit) {
                FormEntry entry = entries.get(offset);
                Model entryModel = (Model)entry.getModel().toArray()[0];
                LinkedHashMap<Object, Object> entryData = new LinkedHashMap<Object, Object>();
                for (ModelItem modelItem : entryModel.getModelItems()) {
                    String name = modelItem.getName();
                    FormQuestion question = form.getQuestion(name);
                    if (question != null) {
                        Object value = question.getType().valueToJSONForClient(entry.getValue(name), question, entry, modelItem);
                        if (value != null) {
                            entryData.put(name, value);
                        }
                    } else {
                        DataContext context = RepositoryDataContext.newInstance().withObject((DataAwareAmetysObject)entry).withDataPath(modelItem.getPath());
                        Object value = entry.dataToJSON(name, context);
                        if (value != null) {
                            entryData.put(name, value);
                        }
                    }
                    if (!matrixLabels.containsKey(name)) continue;
                    entryData.put(name + "matrice-labels", matrixLabels.get(name));
                }
                entryData.put("ametys-user", this._userHelper.user2json(entry.getUser(), true));
                if (form.isQueueEnabled() && entry.isActive().booleanValue()) {
                    entryData.put("ametys-queue-status", this._handleLimitedEntriesHelper.isInQueue(entry));
                }
                entryData.put("ametys-active", entry.isActive());
                entryData.put("ametys-entryId", entries.get(offset).getId());
                entries2json.add(entryData);
                Integer n = offset;
                offset = offset + 1;
            }
        }
        catch (Exception e) {
            this.getLogger().error("Failed to get entries for form '" + form.getId() + "'.", (Throwable)e);
        }
        result.put("entries", entries2json);
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        request.setAttribute(JSonReader.OBJECT_TO_READ, result);
        return EMPTY_MAP;
    }

    protected List<FormEntry> _getEntries(Form form, List<FormEntryDAO.Sort> sorts) {
        if (sorts.isEmpty()) {
            return form.getEntries();
        }
        if (sorts.size() == 1 && "user".equals(sorts.get(0).attributeName())) {
            String direction = sorts.get(0).direction();
            return form.getEntries().stream().sorted((e1, e2) -> "ascending".equals(direction) ? StringUtils.compare((String)this._getUserSortedName((FormEntry)((Object)e1)), (String)this._getUserSortedName((FormEntry)((Object)e2))) : StringUtils.compare((String)this._getUserSortedName((FormEntry)((Object)e2)), (String)this._getUserSortedName((FormEntry)((Object)e1)))).collect(Collectors.toList());
        }
        return this._formEntryDAO.getFormEntries(form, false, sorts);
    }

    private String _getUserSortedName(FormEntry entry) {
        UserIdentity userId = entry.getUser();
        if (userId != null) {
            User user = this._userManager.getUser(userId);
            return user != null ? user.getSortableName() : null;
        }
        return null;
    }

    protected List<FormEntryDAO.Sort> _getSorts(String formId, String sortString, String groupString) {
        ArrayList<FormEntryDAO.Sort> sort = new ArrayList<FormEntryDAO.Sort>();
        ArrayList<Map> sortList = new ArrayList<Map>(this._jsonUtils.convertJsonToList(sortString));
        if (StringUtils.isNotEmpty((CharSequence)groupString)) {
            sortList.add(0, this._jsonUtils.convertJsonToMap(groupString));
        }
        for (Object e : sortList) {
            if (!(e instanceof Map)) continue;
            Map map = (Map)e;
            String fieldId = (String)map.get("property");
            boolean ascending = "ASC".equals(map.get("direction"));
            sort.add(new FormEntryDAO.Sort(StringUtils.contains((CharSequence)fieldId, (CharSequence)formId) ? StringUtils.substringAfter((String)fieldId, (String)formId) : fieldId, ascending ? "ascending" : "descending"));
        }
        return sort;
    }

    protected Map<String, Object> _getMatrixInfos(Form form) {
        HashMap<String, Object> matrixLabels = new HashMap<String, Object>();
        List<FormQuestion> matrixQuestions = form.getQuestions().stream().filter(q -> q.getType() instanceof MatrixQuestionType).toList();
        for (FormQuestion matrixQ : matrixQuestions) {
            MatrixQuestionType type = (MatrixQuestionType)matrixQ.getType();
            Map<String, String> columns = type.getColumns(matrixQ);
            Map<String, String> rows = type.getRows(matrixQ);
            Map matrixInfo = columns == null || rows == null ? Map.of() : Map.of("columns", type.getColumns(matrixQ), "rows", type.getRows(matrixQ));
            matrixLabels.put(matrixQ.getNameForForm(), matrixInfo);
        }
        return matrixLabels;
    }

    private int _getIntValue(Map<String, Object> values, String key, int defaultValue) {
        if (values.containsKey(key)) {
            return Integer.valueOf(values.get(key).toString());
        }
        return defaultValue;
    }
}

