/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.generators;

import com.opensymphony.workflow.loader.StepDescriptor;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import com.opensymphony.workflow.spi.Step;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.ametys.core.util.I18nUtils;
import org.ametys.plugins.forms.dao.FormEntryDAO;
import org.ametys.plugins.forms.generators.FormAdminEntryInformationGenerator;
import org.ametys.plugins.forms.question.FormQuestionType;
import org.ametys.plugins.forms.question.types.impl.ChoicesListQuestionType;
import org.ametys.plugins.forms.question.types.impl.MatrixQuestionType;
import org.ametys.plugins.forms.repository.Form;
import org.ametys.plugins.forms.repository.FormEntry;
import org.ametys.plugins.forms.repository.FormQuestion;
import org.ametys.plugins.workflow.repository.WorkflowAwareAmetysObject;
import org.ametys.plugins.workflow.support.WorkflowProvider;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class FormEntriesToExportGenerator
extends FormAdminEntryInformationGenerator {
    protected WorkflowProvider _workflowProvider;
    protected I18nUtils _i18nUtils;

    @Override
    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._workflowProvider = (WorkflowProvider)smanager.lookup(WorkflowProvider.ROLE);
        this._i18nUtils = (I18nUtils)smanager.lookup(I18nUtils.ROLE);
    }

    @Override
    public void generate() throws IOException, SAXException, ProcessingException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        String formId = request.getParameter("id");
        this.contentHandler.startDocument();
        Form form = (Form)this._resolver.resolveById(formId);
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"form-entries");
        for (FormEntry entry : this._formEntryDAO.getFormEntries(form, false, List.of(new FormEntryDAO.Sort("ametys-id", "ascending")))) {
            this._saxEntry(entry);
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"form-entries");
        this.contentHandler.endDocument();
    }

    @Override
    protected void _checkRights(FormEntry entry) {
    }

    @Override
    protected List<FormQuestion> _getQuestions(FormEntry entry, Optional<Long> currentStepId) {
        Form form = entry.getForm();
        return form.getQuestions().stream().filter(q -> !q.getType().onlyForDisplay((FormQuestion)((Object)q))).toList();
    }

    @Override
    protected void _saxQuestion(FormQuestion question, FormEntry entry) throws SAXException {
        FormQuestionType type = question.getType();
        AttributesImpl attrs = new AttributesImpl();
        attrs.addCDATAAttribute("type", type.getStorageType(question));
        attrs.addCDATAAttribute("typeId", type.getId());
        attrs.addCDATAAttribute("label", question.getTitle());
        attrs.addCDATAAttribute("name", question.getNameForForm());
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"field", (Attributes)attrs);
        if (type instanceof MatrixQuestionType) {
            type.saxEntryValue(this.contentHandler, question, entry);
        } else {
            entry.dataToSAX(this.contentHandler, question.getNameForForm());
            if (type instanceof ChoicesListQuestionType) {
                String value;
                ChoicesListQuestionType choicesListType = (ChoicesListQuestionType)type;
                XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"additional-infos");
                String nameForForm = question.getNameForForm();
                boolean hasOtherValue = choicesListType.hasOtherOption(question);
                if (hasOtherValue && StringUtils.isNotBlank((CharSequence)(value = (String)entry.getValue("ametys-other-" + nameForForm)))) {
                    XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"other", (String)value);
                }
                XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"additional-infos");
            }
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"field");
    }

    @Override
    protected void _addAdditionalEntryAttributes(FormEntry entry, AttributesImpl attrs) {
        super._addAdditionalEntryAttributes(entry, attrs);
        Form form = entry.getForm();
        if (form.hasWorkflow()) {
            WorkflowProvider.AmetysObjectWorkflow workflow = this._workflowProvider.getAmetysObjectWorkflow((WorkflowAwareAmetysObject)entry);
            WorkflowDescriptor workflowDescriptor = workflow.getWorkflowDescriptor(form.getWorkflowName());
            Step currentStep = (Step)workflow.getCurrentSteps(entry.getWorkflowId()).iterator().next();
            StepDescriptor stepDescriptor = workflowDescriptor.getStep(currentStep.getStepId());
            I18nizableText workflowStepName = new I18nizableText("application", stepDescriptor.getName());
            attrs.addCDATAAttribute("status", this._i18nUtils.translate((I18nizable)workflowStepName));
        }
    }
}

