/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.question.autofill;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.forms.question.autofill.AbstractStaticAutoFillSource;
import org.ametys.plugins.forms.repository.FormQuestion;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.model.Enumerator;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.StaticEnumerator;
import org.ametys.runtime.model.ViewElement;
import org.ametys.runtime.model.ViewItem;
import org.ametys.runtime.parameter.DefaultValidator;
import org.ametys.runtime.parameter.Validator;

public class CurrentUserAutoFillSource
extends AbstractStaticAutoFillSource {
    public static final String ATTRIBUTE_AUTOFILL = "autofill";
    public static final String EMAIL_AUTOFILL_VALUE = "email";
    public static final String ID_AUTOFILL_VALUE = "id";
    public static final String FULLNAME_AUTOFILL_VALUE = "fullName";
    public static final String FIRSTNAME_AUTOFILL_VALUE = "firstName";
    public static final String LASTNAME_AUTOFILL_VALUE = "lastName";
    protected Map<String, ModelItem> _defaultAutoFillItems;

    @Override
    public String getAutofillValue(FormQuestion question) {
        User user;
        UserIdentity userIdentity = this._currentUserProvider.getUser();
        User user2 = user = userIdentity != null ? this._userManager.getUser(userIdentity) : null;
        if (user != null) {
            String autofill;
            switch (autofill = (String)question.getValue(ATTRIBUTE_AUTOFILL)) {
                case "email": {
                    return user.getEmail();
                }
                case "id": {
                    return user.getIdentity().getLogin();
                }
                case "fullName": {
                    return user.getFullName();
                }
                case "firstName": {
                    return user.getFirstName();
                }
                case "lastName": {
                    return user.getLastName();
                }
            }
            return null;
        }
        return null;
    }

    @Override
    public Map<String, ModelItem> getModelItems() {
        this._defaultAutoFillItems = new HashMap<String, ModelItem>();
        ElementDefinition autofill = this._formElementDefinitionHelper.getElementDefinition(ATTRIBUTE_AUTOFILL, "string", "PLUGINS_FORMS_QUESTIONS_DIALOG_SIMPLE_TEXT_AUTOFILL", "PLUGINS_FORMS_QUESTIONS_DIALOG_SIMPLE_TEXT_AUTOFILL_DESC", (Validator)new DefaultValidator(null, true));
        StaticEnumerator autofillStaticEnumerator = new StaticEnumerator();
        autofillStaticEnumerator.add(new I18nizableText("plugin.forms", "PLUGINS_FORMS_QUESTIONS_DIALOG_SIMPLE_TEXT_AUTOFILL_EMAIL"), (Object)EMAIL_AUTOFILL_VALUE);
        autofillStaticEnumerator.add(new I18nizableText("plugin.forms", "PLUGINS_FORMS_QUESTIONS_DIALOG_SIMPLE_TEXT_AUTOFILL_ID"), (Object)ID_AUTOFILL_VALUE);
        autofillStaticEnumerator.add(new I18nizableText("plugin.forms", "PLUGINS_FORMS_QUESTIONS_DIALOG_SIMPLE_TEXT_AUTOFILL_FULLNAME"), (Object)FULLNAME_AUTOFILL_VALUE);
        autofillStaticEnumerator.add(new I18nizableText("plugin.forms", "PLUGINS_FORMS_QUESTIONS_DIALOG_SIMPLE_TEXT_AUTOFILL_FIRSTNAME"), (Object)FIRSTNAME_AUTOFILL_VALUE);
        autofillStaticEnumerator.add(new I18nizableText("plugin.forms", "PLUGINS_FORMS_QUESTIONS_DIALOG_SIMPLE_TEXT_AUTOFILL_LASTNAME"), (Object)LASTNAME_AUTOFILL_VALUE);
        autofill.setEnumerator((Enumerator)autofillStaticEnumerator);
        autofill.setDefaultValue((Object)EMAIL_AUTOFILL_VALUE);
        this._defaultAutoFillItems.put(ATTRIBUTE_AUTOFILL, (ModelItem)autofill);
        return this._defaultAutoFillItems;
    }

    @Override
    public List<ViewItem> getViewElements() {
        ArrayList<ViewItem> viewElements = new ArrayList<ViewItem>();
        ViewElement autofill = new ViewElement();
        autofill.setDefinition((ElementDefinition)this._defaultAutoFillItems.get(ATTRIBUTE_AUTOFILL));
        viewElements.add((ViewItem)autofill);
        return viewElements;
    }

    @Override
    public boolean isCacheable(FormQuestion question) {
        return false;
    }
}

