/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.workflow;

import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.ametys.cms.clientsideelement.WorkflowStepsClientSideElement;
import org.ametys.core.ui.Callable;
import org.ametys.core.ui.ClientSideElement;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.commons.collections.ListUtils;

public abstract class AbstractFormEntriesWorkflowStepsClientSideElement
extends WorkflowStepsClientSideElement {
    protected void _configureWorkflowStep(WorkflowDescriptor workflowDescriptor, Integer stepId, Map<String, Object> stepParameters, Configuration stepConfiguration, List<Integer> allowedActionIds) throws ConfigurationException {
        super._configureWorkflowStep(workflowDescriptor, stepId, stepParameters, stepConfiguration, allowedActionIds);
        ArrayList sendMailIds = new ArrayList();
        List currentStepActions = workflowDescriptor.getStep(stepId.intValue()).getActions().stream().mapToInt(action -> ((ActionDescriptor)action).getId()).boxed().collect(Collectors.toList());
        List allowedStepActions = ListUtils.intersection(currentStepActions, allowedActionIds);
        if (stepConfiguration != null) {
            Configuration stepWorkflowSendMail = stepConfiguration.getChild("send-mail", false);
            if (stepWorkflowSendMail != null) {
                sendMailIds.addAll(this._configureWorkflowStepActions(workflowDescriptor.getName(), stepId, currentStepActions, allowedStepActions, stepWorkflowSendMail));
            } else {
                sendMailIds.addAll(allowedStepActions);
            }
        } else {
            sendMailIds.addAll(allowedStepActions);
        }
        stepParameters.put("workflow-send-mail-ids", sendMailIds);
    }

    protected ClientSideElement.Script _configureScript(Configuration configuration) throws ConfigurationException {
        List scriptsImports = this._configureImports(configuration.getChild("scripts"));
        List cssImports = this._configureImports(configuration.getChild("css"));
        ClientSideElement.Script script = new ClientSideElement.Script(this.getId(), "", scriptsImports, cssImports, new HashMap());
        List<ClientSideElement.ScriptFile> scriptFiles = this._getAdditionalScriptFiles();
        script.getScriptFiles().addAll(scriptFiles);
        return script;
    }

    protected abstract List<ClientSideElement.ScriptFile> _getAdditionalScriptFiles();

    protected String _getDefaultPluginName() {
        return "forms";
    }

    protected void _additionalMenuItemConfiguration(Configuration itemConf, DefaultConfiguration classConf, int actionId, Map<String, Object> parameters) {
        super._additionalMenuItemConfiguration(itemConf, classConf, actionId, parameters);
        DefaultConfiguration multiselectConf = new DefaultConfiguration("selection-enable-multiselection");
        multiselectConf.setValue(itemConf.getChild("menu-" + actionId + "-enable-multiselection").getValueAsBoolean(true));
        classConf.addChild((Configuration)multiselectConf);
        this._addActionSendMailConfiguration(itemConf, classConf, actionId, parameters);
    }

    protected void _addActionSendMailConfiguration(Configuration itemConf, DefaultConfiguration classConf, int actionId, Map<String, Object> parameters) {
        DefaultConfiguration sendMailConf = new DefaultConfiguration("send-mail");
        sendMailConf.setValue(itemConf.getChild("menu-" + actionId + "-send-mail").getValueAsBoolean(((List)parameters.get("workflow-send-mail-ids")).contains(actionId)));
        classConf.addChild((Configuration)sendMailConf);
        if (itemConf.getChild("menu-" + actionId + "-dialog-title", false) != null) {
            DefaultConfiguration dialogTitleConf = new DefaultConfiguration("dialog-title");
            dialogTitleConf.setAttribute("i18n", itemConf.getChild("menu-" + actionId + "-dialog-title").getAttribute("i18n", "true"));
            dialogTitleConf.setValue(itemConf.getChild("menu-" + actionId + "-dialog-title").getValue(null));
            classConf.addChild((Configuration)dialogTitleConf);
        }
        if (itemConf.getChild("menu-" + actionId + "-subject-key", false) != null) {
            DefaultConfiguration subjectKeyConf = new DefaultConfiguration("subject-key");
            subjectKeyConf.setAttribute("i18n", itemConf.getChild("menu-" + actionId + "-subject-key").getAttribute("i18n", "true"));
            subjectKeyConf.setValue(itemConf.getChild("menu-" + actionId + "-subject-key").getValue(null));
            classConf.addChild((Configuration)subjectKeyConf);
        }
        if (itemConf.getChild("menu-" + actionId + "-body-key", false) != null) {
            DefaultConfiguration bodyKeyConf = new DefaultConfiguration("body-key");
            bodyKeyConf.setAttribute("i18n", itemConf.getChild("menu-" + actionId + "-body-key").getAttribute("i18n", "true"));
            bodyKeyConf.setValue(itemConf.getChild("menu-" + actionId + "-body-key").getValue(null));
            classConf.addChild((Configuration)bodyKeyConf);
        }
    }

    protected void _configureDefaultDescriptions(Map<String, Object> parameters) {
        if (!parameters.containsKey("entryselected-description")) {
            parameters.put("entryselected-description", new I18nizableText("plugin.forms", "ENTRY_WORKFLOW_DESCRIPTION"));
        }
        if (!parameters.containsKey("several-entryselected-description")) {
            parameters.put("several-entryselected-description", new I18nizableText("plugin.forms", "ENTRIES_WORKFLOW_DESCRIPTION"));
        }
        if (!parameters.containsKey("selection-description-empty")) {
            parameters.put("selection-description-empty", new I18nizableText("plugin.forms", "ENTRY_WORKFLOW_NOSELECTION_DESCRIPTION"));
        }
        if (!parameters.containsKey("selection-description-nomatch")) {
            parameters.put("selection-description-nomatch", new I18nizableText("plugin.forms", "ENTRY_WORKFLOW_NOMATCH_DESCRIPTION"));
        }
        if (!parameters.containsKey("selection-description-multiselectionforbidden")) {
            parameters.put("selection-description-multiselectionforbidden", new I18nizableText("plugin.forms", "ENTRY_WORKFLOW_NOMULTISELECT_DESCRIPTION"));
        }
        if (!parameters.containsKey("noaction-available-description")) {
            parameters.put("noaction-available-description", new I18nizableText("plugin.forms", "ENTRY_WORKFLOW_NOACTIONAVAILABLE_DESCRIPTION"));
        }
        if (!parameters.containsKey("refreshing-description")) {
            parameters.put("refreshing-description", new I18nizableText("plugin.forms", "ENTRY_WORKFLOW_REFRESH_DESCRIPTION"));
        }
    }

    @Callable(rights={"Form_Entries_Rights_Data"}, rightContext="right.assignment.context.formsdirectoryaccess", paramIndex=1)
    public abstract Map<String, Object> getWorkflowState(List<Object> var1, String var2, String var3);
}

