/*
 *  Copyright 2022 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This class controls a open tool ribbon button that is able to check for conditions on
 * the rights of a Form.
 * @private
 */
Ext.define('Ametys.plugins.forms.controllers.OpenFormRightsToolController', {
	extend: 'Ametys.ribbon.element.ui.button.OpenToolButtonController',

	constructor: function (config)
	{
		this.callParent(arguments);
		Ametys.message.MessageBus.on(Ametys.message.Message.MODIFIED, this._onFormModified, this);
	},
	
	additionalErrorDescriptionOnSelectionChanged: function(targets)
	{
        if (!targets[0].getParameters().canEditRight)
        {
            return this.getInitialConfig('description-no-writeaccess') || '';
        }
	},
	
	/**
	 * Listener on modified message.
	 * Update the state of the controller accordingly.
	 * @param {Ametys.message.Message} message the message of type modified.
	 * @private
	 */
	_onFormModified: function(message)
	{
        if (this.updateTargetsInCurrentSelectionTargets(message))
        {
            this.refresh();
        }
	}
});
	
