<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2021 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
    xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
    xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper" 
    xmlns:exsl="http://exslt.org/common"
    exclude-result-prefixes="ametys">
    
    <xsl:template match="question[@type = 'form.Matrix']" mode="question-attribute-class">
        <xsl:attribute name="class">question question-matrix</xsl:attribute>
    </xsl:template>
    
    <xsl:template match="question[@type = 'form.Matrix']" mode="field-attribute-class">
        <xsl:attribute name="class">field field-matrix</xsl:attribute>
    </xsl:template>
    
    <xsl:template match="question[@type = 'form.Matrix']" mode="read-only">
        <div class="{$cssPrefix}__item_value">
            <xsl:choose>
                <xsl:when test="entry-value/value/option">
                    <xsl:apply-templates select="." mode="read-only-value">
                        <xsl:with-param name="value" select="entry-value/value" />
                    </xsl:apply-templates>    
                </xsl:when>
                <xsl:otherwise>
                    <i18n:text i18n:key="PLUGINS_FORMS_SERVICE_DASHBOARD_ENTRY_EMPTY_VALUE" i18n:catalogue="plugin.forms"/>
                </xsl:otherwise>
            </xsl:choose>
        </div>
    </xsl:template> 
    
    <xsl:template match="question[@type = 'form.Matrix']" mode="read-only-value">
        <xsl:param name="value" />
        
        <ul>
            <xsl:for-each select="additional-infos/options/option">
                <xsl:variable name="optValue" select="@value"/> 
                <xsl:variable name="optLabel" select="."/> 
                <xsl:variable name="val">
                    <xsl:for-each select="$value/option[@value=$optValue]/value">
                        <xsl:variable name="colValue" select="."/>
                        <xsl:value-of select="../../../additional-infos/columns/column[@value= $colValue]"/>
                        <xsl:if test="position() != last()">, </xsl:if>
                    </xsl:for-each>
                </xsl:variable>
                <xsl:if test="$val != ''">
                    <li>
                        <xsl:value-of select="$optLabel" />
                        <xsl:text>: </xsl:text>
                        <xsl:value-of select="$val" />
                    </li>
                </xsl:if>
            </xsl:for-each>
        </ul>
    </xsl:template>
    
    <xsl:template match="question[@type = 'form.Matrix']" mode="render-mail">
        <ul>
            <xsl:for-each select="additional-infos/options/option">
                <xsl:variable name="optValue" select="@value"/> 
                <xsl:variable name="optLabel" select="@label"/> 
                <xsl:variable name="val">
                    <xsl:for-each select="../../../value/option[@value=$optValue]/value">
                        <xsl:variable name="colValue" select="."/>
                        <xsl:value-of select="../../../additional-infos/columns/column[@value= $colValue]"/>
                        <xsl:if test="position() != last()">, </xsl:if>
                    </xsl:for-each>
                </xsl:variable>
                <xsl:if test="$val != ''">
                    <li>
                        <xsl:value-of select="$optLabel" />
                        <xsl:text>: </xsl:text>
                        <xsl:value-of select="$val" />
                    </li>
                </xsl:if>
            </xsl:for-each>
        </ul>
    </xsl:template>
    
    <xsl:template match="question[@type = 'form.Matrix']" mode="input">
        <xsl:variable name="multiple" select="multiple"/>
        <xsl:variable name="mandatory" select="mandatory"/>
        <xsl:variable name="questionHiddenId" ><xsl:value-of select="$uniqueId"/>-q-hidden-<xsl:value-of select="@name"/></xsl:variable>
        <xsl:variable name="name" select="@name"/>
        
        <xsl:variable name="entryOptions" select="entry-value/additional-infos/options"/>
        <table class="table-matrix">
            <thead>
                <tr>
                    <th></th>
                    <xsl:for-each select="additional-infos/columns/column">
                        <th><xsl:value-of select="."/></th>
                    </xsl:for-each>
                </tr>
            </thead>
            
            <tbody>
                <xsl:for-each select="additional-infos/options/option">
                    <xsl:variable name="lineValue" select="@value"/>
                    <xsl:variable name="lineText" select="."/>
                    <xsl:variable name="optName" select="concat($name, '_', $lineValue)"/>
                    <tr>
                        <td><xsl:value-of select="$lineText"/></td>
                        
                        <xsl:variable name="optIdx" select="position()"/>
                        <xsl:variable name="entryOption" select="$entryOptions/option[$optIdx]"/>
                        
                        <xsl:for-each select="../../columns/column">
                            <xsl:variable name="colText" select="."/>
                            <xsl:variable name="colValue" select="@value"/>
                            <td>
                                <xsl:variable name="title">
                                    <arg><xsl:value-of select="$lineText"/></arg>
                                    <arg><xsl:value-of select="$colText"/></arg>
                                </xsl:variable>
                                
                                <xsl:variable name="colIdx" select="position()"/>
                                
                                <div class="input input-radio">
                                    <xsl:if test="$multiple = 'true'">
                                        <xsl:attribute name="class">input input-checkbox</xsl:attribute>
                                    </xsl:if>
                                    <input onclick="AmetysFormsHelper.onFormMatrixChange('{$questionHiddenId}', '{$optName}', '{$lineValue}', '{$colValue}', {$mandatory})" 
                                           name="{$optName}" 
                                           id="{translate($optName, ' ', '_')}_{$uniqueId}_{translate($colValue, ' ', '_')}" 
                                           value="{$colValue}" 
                                           title="{ametys:translate('plugin.forms:PLUGINS_FORMS_SERVICE_MATRIX_TITLE', $lang, exsl:node-set($title))}"
                                           type="radio">
                                            <xsl:if test="$multiple = 'true'">
                                                <xsl:attribute name="type">checkbox</xsl:attribute>
                                            </xsl:if>
                                            <xsl:if test="$entryOption/value[$colIdx]/@checked = 'true'">
                                                <xsl:attribute name="checked">true</xsl:attribute>
                                                <script type="text/javascript">
                                                    $j( document ).ready(function() {
                                                        AmetysFormsHelper.onFormMatrixChange('<xsl:value-of select="$questionHiddenId" />', '<xsl:value-of select="$optName" />', '<xsl:value-of select="$lineValue" />', '<xsl:value-of select="$colValue"/>', <xsl:value-of select="$mandatory"/>);
                                                    });
                                                </script>
                                            </xsl:if>
                                    </input>
                                </div>
                            </td>
                        </xsl:for-each>
                    </tr>
                </xsl:for-each>
            </tbody>
        </table>
        <input id="{$questionHiddenId}" type="hidden" name="{@name}" value="" />
    </xsl:template> 
    
    <xsl:template match="question[(@type = 'form.Matrix') and mandatory = 'true']" mode="check-mandatory">
        <xsl:variable name="name" select="@name"/>
        var parentField = $j('#form-<xsl:value-of select="$uniqueId"/>-q-<xsl:value-of select="@name"/>');
        var field = $j("#field-<xsl:value-of select="$name"/>_<xsl:value-of select="$uniqueId"/>")
        if (!field.is(":hidden") &amp;&amp; !field.prop('disabled')  &amp;&amp; !parentField.hasClass("preview-hide"))
        {
            var atLeastEmptyLine = false;
            <xsl:for-each select="additional-infos/options/option">
                <xsl:variable name="lineText" select="."/>
                <xsl:variable name="lineValue" select="@value"/>
                <xsl:variable name="optName" select="concat($name, '_', $lineValue)"/>
            
                var isEmpty = true;
                $j('input[name="<xsl:value-of select="$optName"/>"]').each(function( index ) {
    	            if ($j(this).is(':checked'))
    	            {
    	               isEmpty = false;
    	            }
                });
                
                if (isEmpty)
                {
                    atLeastEmptyLine = true;
                }
            </xsl:for-each>     
            
            if (atLeastEmptyLine)
            {
                <xsl:variable name="questionHiddenId" ><xsl:value-of select="$uniqueId"/>-q-hidden-<xsl:value-of select="@name"/></xsl:variable>
                AmetysFormsHelper.addFormError('<xsl:value-of select="$uniqueId"/>', '<xsl:value-of select="$questionHiddenId"/>', '<xsl:value-of select="ametys:escapeJS(title)"/>', "<i18n:text i18n:key="PLUGINS_FORMS_FORM_ERROR_MANDATORY_MATRIX"/>");
            }   
        }            
    </xsl:template>
</xsl:stylesheet>