/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.forms.content;

import java.util.HashMap;
import java.util.Map;

/**
 * Class representing a form field.
 */
public class Field
{
    /**
     * Field type.
     */
    public static enum FieldType
    {
        /** Text input */
        TEXT,
        /** Textarea */
        TEXTAREA,
        /** Select list */
        SELECT,
        /** Checkbox */
        CHECKBOX,
        /** Radio button */
        RADIO,
        /** Password */
        PASSWORD,
        /** File upload control */
        FILE,
        /** Hidden value */
        HIDDEN,
        /** Display cost */
        COST,
        /** Captcha */
        CAPTCHA
    }
    
    /** The field ID. */
    protected String _id;
    
    /** The field type. */
    protected FieldType _type;
    
    /** The field name. */
    protected String _name;
    
    /** The field label. */
    protected String _label;
    
    /** The field properties. */
    protected Map<String, String> _properties;
    
    /**
     * Default constructor.
     * @param type the field type.
     */
    public Field(FieldType type)
    {
        this("", type, "", "", new HashMap<>());
    }
    
    /**
     * Constructor with parameters.
     * @param id the field ID.
     * @param type the field type.
     * @param name the field name.
     * @param label the field label.
     * @param properties the field properties.
     */
    public Field(String id, FieldType type, String name, String label, Map<String, String> properties)
    {
        this._id = id;
        this._type = type;
        this._name = name;
        this._label = label;
        this._properties = properties;
    }

    /**
     * Get the id.
     * @return the id
     */
    public String getId()
    {
        return _id;
    }

    /**
     * Set the id.
     * @param id the id to set
     */
    public void setId(String id)
    {
        this._id = id;
    }
    
    /**
     * Get the type.
     * @return the type
     */
    public FieldType getType()
    {
        return _type;
    }
    
    /**
     * Set the type.
     * @param type the type to set
     */
    public void setType(FieldType type)
    {
        this._type = type;
    }
    
    /**
     * Get the name.
     * @return the name
     */
    public String getName()
    {
        return _name;
    }

    /**
     * Set the name.
     * @param name the name to set
     */
    public void setName(String name)
    {
        this._name = name;
    }

    /**
     * Get the label.
     * @return the label
     */
    public String getLabel()
    {
        return _label;
    }

    /**
     * Set the label.
     * @param label the label to set
     */
    public void setLabel(String label)
    {
        this._label = label;
    }

    /**
     * Get the properties.
     * @return the properties
     */
    public Map<String, String> getProperties()
    {
        return _properties;
    }

    /**
     * Set the properties.
     * @param properties the properties to set
     */
    public void setProperties(Map<String, String> properties)
    {
        this._properties = properties;
    }
    
}
