/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.forms.content;

import java.util.ArrayList;
import java.util.List;

/**
 * Class representing a form fieldset.
 */
public class Fieldset
{
    
    /** The fieldset label. */
    protected String _label;
    
    /** The IDs of the fields contained in this fieldset. */
    protected List<String> _fieldIds;
    
    /**
     * Default constructor.
     */
    public Fieldset()
    {
        this("", new ArrayList<>());
    }
    
    /**
     * Constructor with parameters.
     * @param label the fieldset label.
     * @param fieldIds the field IDs.
     */
    public Fieldset(String label, List<String> fieldIds)
    {
        this._label = label;
        this._fieldIds = fieldIds;
    }
    
    /**
     * Get the label.
     * @return the label
     */
    public String getLabel()
    {
        return _label;
    }

    /**
     * Set the label.
     * @param label the label to set
     */
    public void setLabel(String label)
    {
        this._label = label;
    }

    /**
     * Get the the field IDs.
     * @return the the field IDs
     */
    public List<String> getFieldIds()
    {
        return _fieldIds;
    }

    /**
     * Set the the field IDs.
     * @param fieldIds the field IDs to set
     */
    public void setProperties(List<String> fieldIds)
    {
        this._fieldIds = fieldIds;
    }
    
}
