/*
 *  Copyright 2021 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.forms.question.sources;

import java.util.Map;

/**
 * Class for creating choices options with costs
 */
public class ChoiceOptionWithCost extends ChoiceOption
{
    private Double _cost;

    /**
     * Create a {@link ChoiceOptionWithCost}
     * @param value value of option
     * @param cost cost of option
     */
    public ChoiceOptionWithCost(Object value, Double cost)
    {
        super(value);
        _cost = cost;
    }

    /**
     * Get the cost of option
     * @return the cost
     */
    public Double getCost()
    {
        return _cost;
    }
    
    @Override
    public Map<String, Object> getAttributes() 
    {
        Map<String, Object> attrs = super.getAttributes();
        attrs.put("cost", String.valueOf(getCost()));
        return attrs;
    }
}
